import request from '@/utils/request'

// 查询所有项目
export function projectSelect(query) {
    return request({
        url: '/djl-recruit/releasedproject/queryallproject',
        method: 'get',
        params: query
    })
}
// 查询所有招聘厂商
export function manufacturerSelect(query) {
    return request({
        url: '/djl-recruit/manufacturer/query/list',
        method: 'get',
        params: query
    })
}
// 查询项目列表
export function projectL(query) {
    return request({
        url: '/djl-recruit/releasedproject/query/projectList',
        method: 'get',
        params: query
    })
}
// 下载二维码
export function getWxQrCode(data) {
    return request({
        url: '/djl-recruit/channeweixinlqrcode/download/base64/qrcode',
        method: 'get',
        params: data
    })
}
export function getQrCode(data) {
    return request({
        url: '/djl-recruit/channelqrcode/download/base64/qrcode',
        method: 'get',
        params: data
    })
}
// 获取项目详情
export function projectDetails(data) {
    return request({
        url: '/djl-recruit/releasedproject/query/single',
        method: 'get',
        params: data
    })
}
// 查询接站地列表
export function projectStationList(data) {
    return request({
        url: '/djl-recruit/releasedproject/query/station/list',
        method: 'get',
        params: data
    })
}
// 查询此项目是否第一次执行雇员报备
export function queryChannelProject(data) {
    return request({
        url: '/djl-recruit/recruitpersonnel/querychannelproject',
        method: 'get',
        params: data
    })
}

// 查询所有招聘政策
export function pricePolicyListSelect(data) {
    return request({
        url: '/djl-recruit/releasedpricepolicy/queryallpricepolicy',
        method: 'get',
        params: data
    })
}
// 查询所有招聘政策
export function insertChannelProject(data) {
    return request({
        url: '/djl-recruit/recruitpersonnel/insertchannelproject',
        method: 'post',
        data: data
    })
}
// 报备页面-查询列表
export function recruitPersonnelL(data) {
    return request({
        url: '/djl-recruit/recruitpersonnel/query/list',
        method: 'get',
        params: data
    })
}
//报备页面-解析证件号码
export function parseIdNo(data){
    return request({
        url: '/djl-recruit/recruitpersonnel/parse/id_no',
        method: 'get',
        params: data
    })
}
//报备页面-校验证件号码是否重复
export function checkIdNo(data){
    return request({
        url: '/djl-recruit/recruitpersonnel/check/id_no',
        method: 'get',
        params: data
    })
}
//报备页面-新增 新增项目报备的雇员信息
export function recruitPersonC(data) {
    return request({
        url: '/djl-recruit/recruitpersonnel/insert',
        method: 'post',
        data: data
    })
}
//报备页面-编辑 更新项目报备的雇员信息
export function recruitPersonU(data) {
    return request({
        url: '/djl-recruit/recruitpersonnel/update',
        method: 'post',
        data: data
    })
}
//报备页面-删除 删除项目报备的雇员信息
export function recruitPersonD(data) {
    return request({
        url: '/djl-recruit/recruitpersonnel/delete',
        method: 'post',
        data: data
    })
}
//报备页面-检查是否有正在导入的数据
export function recruitPersonCheckImporting(data){
    return request({
        url: '/djl-recruit/importpeportpersonnel/check/is_importing',
        method: 'get',
        params: data
    })
}
//导入雇员
export function importRecruitPerson(data) {
    return request({
        url: '/djl-recruit/importpeportpersonnel/import',
        method: 'post',
        data: data
    })
}
//导入中间页-查询列表  查询正在导入的雇员临时数据
export function recruitPersonImportL(data){
    return request({
        url: '/djl-recruit/importpeportpersonnel/query/import',
        method: 'get',
        params: data
    })
}
//导入中间页-编辑  更新雇员导入临时数据
export function recruitPersonImportU(data) {
    return request({
        url: '/djl-recruit/importpeportpersonnel/update',
        method: 'post',
        data: data
    })
}
//导入中间页-编辑 校验证件号码
export function recruitPersonImportCheckIdNo(data){
    return request({
        url: '/djl-recruit/importpeportpersonnel/check/id_no',
        method: 'get',
        params: data
    })
}
//导入中间页-删除
export function recruitPersonImportD(data){
    return request({
        url: '/djl-recruit/importpeportpersonnel/delete',
        method: 'get',
        params: data
    })
}
//导入中间页-批量删除
export function recruitPersonImportBatchD(data){
    return request({
        url: '/djl-recruit/importpeportpersonnel/batchdelete',
        method: 'post',
        data: data
    })
}
//导入中间页-删除全部雇员导入临时数据
export function recruitPersonImportClear(data){
    return request({
        url: '/djl-recruit/importpeportpersonnel/clear',
        method: 'get',
        params: data
    })
}
//导入中间页-确认入库 提交导入数据
export function recruitPersonImportSubmit(data){
    return request({
        url: '/djl-recruit/importpeportpersonnel/import/submit',
        method: 'get',
        params: data
    })
}
//查询导入中间页正确数据、错误数据的条数
export function importTypeCount(data){
    return request({
        url: '/djl-recruit/importpeportpersonnel/query/import/typecount',
        method: 'get',
        params: data
    })
}