import { createWebHistory, createRouter,createWebHashHistory } from 'vue-router'
/* Layout */
import Layout from '@/layout'

/**
 * Note: 路由配置项
 *
 * hidden: true                     // 当设置 true 的时候该路由不会再侧边栏出现 如401，login等页面，或者如一些编辑页面/edit/1
 * alwaysShow: true                 // 当你一个路由下面的 children 声明的路由大于1个时，自动会变成嵌套的模式--如组件页面
 * redirect                         // 默认跳转路径
 * name:'router-name'               // 设定路由的名字，一定要填写不然使用<keep-alive>时会出现各种问题
 * query: '{"id": 1, "name": "ry"}' // 访问路由的默认传递参数
 * roles: ['admin', 'common']       // 访问路由的角色权限
 * permissions: ['a:a:a', 'b:b:b']  // 访问路由的菜单权限
 * meta : {
    noCache: true                   // 如果设置为true，则不会被 <keep-alive> 缓存(默认 false)
    title: 'title'                  // 设置该路由在侧边栏和面包屑中展示的名字
    icon: 'svg-name'                // 设置该路由的图标，对应路径src/assets/icons/svg
    breadcrumb: false               // 如果设置为false，则不会在breadcrumb面包屑中显示
    activeMenu: '/system/user'      // 当路由设置了该属性，则会高亮相对应的侧边栏。
    clickable: noRedirect             // 当设置 noRedirect 的时候该路由在面包屑导航中不可被点击
    preTitle // 面包屑导航上层的名称
    preTitle2 // 面包屑导航preTitle之后与本页面之间的名称
  }
 */

// 公共路由
export const constantRoutes = [
  {
    path: '/login',
    component: () => import('@/views/login'),
    hidden: true
  },
  {
    path: "/:pathMatch(.*)*",
    component: () => import('@/views/error/404'),
    hidden: true
  },
  {
    path: '/401',
    component: () => import('@/views/error/401'),
    hidden: true
  },
  {
    path: "/qrCodeSuccess",
    name: "qrCodeSuccess",
    component: () => import("@/views/qrCodeSuccess.vue"),
  },
  {
    path: '/',
    component: Layout,
    redirect: '/dispatch',
    // meta: { title: '项目', icon: 'redis' },
    children: [
      {
        path: 'dispatch',
        component: () => import('@/views/dispatch/index'),
        name: 'dispatch',
        meta: { title: '客户（派遣公司）管理', icon: 'redis' }
      },
      {
        "name": "salary_advance",
        "path": "dispatch/salary/advance",
        "hidden": true,
        "component": () => import('@/views/dispatch/salary_advance_interval'),
        "meta": {
          "title": "预支工资设置",
          "icon": "online",
          "preTitle":"客户（派遣公司）管理",
          "activeMenu":"/dispatch"
        }
      },
      {
        "name": "add",
        "path": "dispatch/add",
        "hidden": true,
        "component": () => import('@/views/dispatch/add'),
        "meta": {
          "title": "新增",
          "icon": "online",
          "preTitle":"客户（派遣公司）管理",
          "activeMenu":"/dispatch"
        }
      },
      {
        "name": "edit",
        "path": "dispatch/edit",
        "hidden": true,
        "component": () => import('@/views/dispatch/add'),
        "meta": {
          "title": "编辑",
          "icon": "online",
          "preTitle":"客户（派遣公司）管理",
          "activeMenu":"/dispatch"
        }
      },
    ]
  },
  {
    path: '/',
    component: Layout,
    redirect: '/channel',
    // meta: { title: '项目', icon: 'redis' },
    children: [
      {
        path: 'channel',
        component: () => import('@/views/archives/channel/index'),
        name: 'channel',
        meta: { title: '渠道管理', icon: 'qudao' }
      },
    ]
  },
  {
    path: '/',
    component: Layout,
    redirect: '/person',
    // meta: { title: '项目', icon: 'redis' },
    children: [
      {
        path: 'person',
        component: () => import('@/views/account/person/index'),
        name: 'person',
        meta: { title: 'C端账号管理', icon: 'people' }
      },
    ]
  },
  {
    path: '/',
    component: Layout,
    redirect: '/person/archives',
    // meta: { title: '项目', icon: 'redis' },
    children: [
      {
        path: 'person/archives',
        component: () => import('@/views/archives/personnel/index'),
        name: 'person/archives',
        meta: { title: '人才库', icon: 'peoples' }
      },
      {
        "name": "details",
        "path": "person/archives/details",
        "hidden": true,
        "component": () => import('@/views/archives/personnel/details'),
        "meta": {
          "title": "详情",
          "icon": "online",
          "preTitle":"人才库",
          "activeMenu":"/person/archives"
        }
      },
    ]
  },
  {
    path: '/',
    component: Layout,
    redirect: '/bill',
    children: [
      {
        path: 'bill',
        component: () => import('@/views/bill/index'),
        name: 'bill',
        meta: { title: '预支工资账单', icon: 'form' }
      },
      {
        "name": "billDetails",
        "path": "bill/details",
        "hidden": true,
        "component": () => import('@/views/bill/details'),
        "meta": {
          "title": "账单明细",
          "preTitle":"预支工资账单",
          "activeMenu":"/bill"
        }
      },
    ]
  }
  // {
  //   path: "/channel",
  //   component: Layout,
  //   redirect: "arrived",
  //   meta: {
  //     clickable: 'noRedirect',
  //     title: "人员跟踪",
  //     icon: "monitor",
  //     noCache: false,
  //     link: null
  //   },
  //   children: [
  //     {
  //       name: "recruit_personnel",
  //       path: "personnel",
  //       hidden: false,
  //       component: ()  => import('@/views/recruit/channel_personnel/index'),
  //       meta: {
  //         title: "雇员状态查询",
  //         icon: "online",
  //         noCache: false,
  //         link: null
  //       }
  //     },
  //     {
  //       name: "recruit_bycar",
  //       path: "bycar",
  //       hidden: false,
  //       component: ()  => import('@/views/recruit/channel_bycar/index'),
  //       meta: {
  //         title: "出发记录",
  //         icon: "online",
  //         noCache: false,
  //         link: null
  //       }
  //     },
  //   ]
  // },
]

// 动态路由，基于用户权限动态去加载
export const dynamicRoutes = []

const router = createRouter({
  history: createWebHashHistory(),
  routes: constantRoutes,
  scrollBehavior(to, from, savedPosition) {
    if (savedPosition) {
      return savedPosition
    } else {
      return { top: 0 }
    }
  },
});

export default router;
