import request from '@/utils/request'

// 查询派遣公司列表
export function dispatchL(query) {
    return request({
        url: '/djl-role/dispatch/query/list',
        method: 'get',
        params: query
    })
}
// 新增 预支额度设置
export function salaryAdvanceInsert(data) {
    return request({
        url: '/djl-role/salary/advance/insert',
        method: 'post',
        data: data
    })
}
// 获取当前派遣公司下设置的预支工资额度
export function salaryAdvanceSingle(data) {
    return request({
        url: '/djl-role/salary/advance/by/baseCode',
        method: 'get',
        params: data
    })
}
// 编辑 预支额度设置
export function salaryAdvanceUpdate(data) {
    return request({
        url: '/djl-role/salary/advance/update',
        method: 'post',
        data: data
    })
}
// 校验派遣公司名称是否重复  校验名称
export function checkName(data) {
    return request({
        url: '/djl-role/dispatch/check/name',
        method: 'get',
        params: data
    })
}
// 校验派遣公司账号是否重复  校验默认账号
export function checkAccount(data) {
    return request({
        url: '/djl-role/dispatch/check/default_account',
        method: 'get',
        params: data
    })
}
// 校验派遣公司编号是否重复  校验baseCode
export function checkBaseCode(data) {
    return request({
        url: '/djl-role/dispatch/check/baseCode',
        method: 'get',
        params: data
    })
}
// 新增派遣公司  新增
export function dispatchC(data) {
    return request({
        url: '/djl-role/dispatch/insert',
        method: 'post',
        data: data
    })
}
// 编辑派遣公司  更新
export function dispatchU(data) {
    return request({
        url: '/djl-role/dispatch/update',
        method: 'post',
        data: data
    })
}
// 获取派遣公司详情
export function getDetails(data) {
    return request({
        url: '/djl-role/dispatch/query/single',
        method: 'get',
        params: data
    })
}
// 停用电子合同
export function stopContract(data) {
    return request({
        url: '/djl-role/dispatch/stop',
        method: 'post',
        data: data
    })
}
// 启用电子合同
export function startContract(data) {
    return request({
        url: '/djl-role/dispatch/start',
        method: 'post',
        data: data
    })
}

// 新增 平台与客户分成比例
export function salaryAdvanceIntervalC(data) {
    return request({
        url: '/djl-role/salary/advance/interval/c',
        method: 'post',
        data: data
    })
}
// 获取当前派遣公司下设置的预支工资额度
export function salaryAdvanceIntervalSingle(data) {
    return request({
        url: '/djl-role/salary/advance/interval/by/baseCode',
        method: 'get',
        params: data
    })
}
// 编辑 预支额度设置
export function salaryAdvanceIntervalU(data) {
    return request({
        url: '/djl-role/salary/advance/interval/u',
        method: 'post',
        data: data
    })
}