import request from '@/utils/request'

// 登录方法
export function login(formData) {
  return request({
    url: '/djl-auth/loginform',
    headers: {
      isToken: false,
      repeatSubmit: false
    },
    method: 'post',
    data: formData
  })
}
// 构造微信登录授权URL
export function getLoginQRcode(data) {
  return request({
    url: '/djl-account/wx/channel/login/url',
    method: 'get',
    params: data
  })
}
// 前台轮询接口，查询登录二维码状态
export function loginState(data) {
  return request({
    url: '/djl-account/wx/channel/check/login/state',
    method: 'get',
    params: data
  })
}