package com.jxjy.system.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.jxjy.system.bean.auth.UserContext;
import com.jxjy.system.mapper.CollectMapper;
import com.jxjy.system.service.CollectService;
import com.jxjy.system.util.auth.UserUtils;
import com.jxjy.system.xsnowflake.SnowFlakeFactory;
import data.system.Collect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 *
 * @return: 收藏管理
 * @Author: wml
 * @Date 2025/5/9 10:22
 */
@Service
@Transactional
public class CollectServiceImpl extends ServiceImpl<CollectMapper, Collect> implements CollectService {

    @Autowired
    SnowFlakeFactory snowFlakeFactory;


    /**
     * @description: 获取收藏列表
     * @author: wangmenglong
     * @date; 2023/12/11 16:46
     * @param: [pageNum, pageSize]
     * @return: java.util.List<data.collect.Collect>
     **/
    @Override
    public List<Collect> list(int pageNum, int pageSize, Collect collect) {
        //启动分页工具
        PageHelper.startPage(pageNum, pageSize);
        //创建查询条件
        LambdaQueryWrapper<Collect> qw = new LambdaQueryWrapper<>();
        qw.like(StringUtils.isNotBlank(collect.getPersonId()),Collect::getPersonId,collect.getPersonId())
                .eq(Collect::getDel,false)
                .eq(StringUtils.isNotBlank(collect.getBaseCode()),Collect::getBaseCode, collect.getBaseCode())
                .orderByDesc(Collect::getCreateTime);
        List<Collect> collectList = super.list(qw);
        //返回查询结果
        return collectList;
    }


    /**
     * @description: 新增收藏
     * @author: wangmenglong
     * @date; 2023/12/11 16:51
     * @param: [collect]
     * @return: boolean
     **/
    @Override
    public boolean create(Collect collect) {

        UserContext userContext = UserUtils.getUserContext();
        String baseCode = userContext.getBaseCode();

        collect.setId(snowFlakeFactory.nextId());
        collect.setBaseCode(baseCode);
        collect.setDel(false);
        collect.setCreateTime(DateUtil.now());

        return super.save(collect);
    }

    /**
     * @description: 编辑收藏
     * @author: wangmenglong
     * @date; 2023/12/11 16:55
     * @param: [collect]
     * @return: boolean
     **/
    @Override
    public boolean update(Collect collect) {
        collect.setUpdateTime(DateUtil.now());
        //判断是否传入id
        if(StringUtils.isBlank(collect.getId())){
            return false;
        }
        return super.saveOrUpdate(collect);
    }

    /**
     * @description: 删除收藏
     * @author: wangmenglong
     * @date; 2023/12/11 17:06
     * @param: [id]
     * @return: boolean
     **/
    @Override
    public boolean del(String recruitId,String personId) {
        if(StringUtils.isBlank(recruitId)||StringUtils.isBlank(personId)){
            return false;
        }
        LambdaUpdateWrapper<Collect> qw = new LambdaUpdateWrapper<>();
        qw.eq(Collect::getRecruitId,recruitId).eq(Collect::getPersonId,personId)
                .set(Collect::getDel,true)
                .set(Collect::getDelTime, DateUtil.now());

        return super.update(qw);
    }


    /**
     * @author: wangmenglong
     * @date; 2024/3/24 17:19
     * @description: 获取收藏详情
     * @param: [id]
     * @return: data.collect.Collect
     **/
    @Override
    public Collect getDetails(String id) {
        return super.getById(id);
    }


    /**
     * @author: wangmenglong
     * @date; 2024/1/2 14:30
     * @description: 判断是否存在
     * @param: [account, id]
     * @return: boolean
     **/
    @Override
    public boolean isHave(String recruitId, String personId) {
        LambdaQueryWrapper<Collect> qw = new LambdaQueryWrapper<>();
        qw.eq(Collect::getDel,false)
                .eq(Collect::getRecruitId, recruitId)
                .eq(Collect::getPersonId, personId);
        return super.count(qw)>0;
    }

}
