package com.jxjy.system.service.impl;

import com.jxjy.system.mapper.OrgMapper;
import com.jxjy.system.mapper.PersonMapper;
import com.jxjy.system.mapper.SignRecordMapper;
import com.jxjy.system.service.BiService;
import com.jxjy.system.service.OrgService;
import data.system.Org;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 *
 * @return: 统计管理管理
 * @Author: wml
 * @Date 2025/5/9 10:22
 */
@Service
@Transactional
public class BiServiceImpl implements BiService {

    @Resource
    SignRecordMapper signRecordMapper;

    @Resource
    PersonMapper personMapper;

    @Resource
    OrgMapper orgMapper;

    @Resource
    OrgService orgService;

    @Override
    public List<Map<String, Object>> biCity() {
        return signRecordMapper.biCity();
    }

    @Override
    public List<Map<String, Object>> biPersonProvince() {
        return personMapper.biPersonAmount();
    }

    @Override
    public List<Map<String, Object>> biOrgProvince() {

        List<Map<String, Object>>  list =orgMapper.biOrgAmount();
        for (Map<String, Object> map : list) {
            String province = map.get("province").toString();
            List<Org> orgList = orgService.listAllByProvince(province);
            map.put("orgList", orgList.stream().map(Org::getName).collect(Collectors.toList()));
        }

        return list;
    }

    @Override
    public List<Map<String, Object>> biRecruit() {
        return signRecordMapper.biRecruit();
    }

    @Override
    public List<Map<String, Object>> biRecruitEntry() {
        return signRecordMapper.biRecruitEntry();
    }

    @Override
    public List<Map<String, Object>> biRecruitReport() {
        return signRecordMapper.biRecruitReport();
    }

    @Override
    public List<Map<String, Object>> biRecruitLineByMonth() {


        List<Map<String, Object>> biReportByMonthList = signRecordMapper.biReportByMonth();
        List<Map<String, Object>> biEntryByMonthList = signRecordMapper.biEntryByMonth();

        int daysInCurrentMonth = LocalDate.now().lengthOfMonth();

        //循环一下月份，输出一个列表
        List<Map<String, Object>> list = new ArrayList<>();
        for (int i = 1; i <= daysInCurrentMonth; i++) {
            Map<String, Object> map = new HashMap<>();
            map.put("reportAmount", "0");
            map.put("entryAmount", "0");

            //获取当前年月字符串，按照yyyy-MM表示
            String currentYear = LocalDate.now().getYear()+"";
            String currentMonth = LocalDate.now().getMonthValue()+"";
            if(currentMonth.length()==1){
                currentMonth = "0"+currentMonth;
            }
            if(i<=9){
                map.put("day", currentYear+"-"+currentMonth+"-0"+i);
            }else {
                map.put("day", currentYear+"-"+currentMonth+"-"+i);
            }

            //循环biReportByMonthList
            for (Map<String, Object> biReportByMonth : biReportByMonthList) {
                if (biReportByMonth.get("day").toString().equals(map.get("day"))) {
                    map.put("reportAmount", biReportByMonth.get("amount"));
                }
            }

            //循环biReportByMonthList
            for (Map<String, Object> biEntryByMonth : biEntryByMonthList) {
                if (biEntryByMonth.get("day").toString().equals(map.get("day"))) {
                    map.put("entryAmount", biEntryByMonth.get("amount"));
                }
            }

            list.add(map);
        }


        return list;
    }

    @Override
    public List<Map<String, Object>> biRecruitLineByYear() {

        int currentYear = LocalDate.now().getYear();

        List<Map<String, Object>> biReportByMonthList = signRecordMapper.biReportByYear();
        List<Map<String, Object>> biEntryByMonthList = signRecordMapper.biEntryByYear();

        //循环一下当年的月份，输出一个列表
        List<Map<String, Object>> list = new ArrayList<>();
        for (int i = 1; i <= 12; i++) {
            Map<String, Object> map = new HashMap<>();
            map.put("reportAmount", "0");
            map.put("entryAmount", "0");

            if(i<=9){
                map.put("day", currentYear+"-0"+i);
            }else {
                map.put("day", currentYear+"-"+i);
            }


            //循环biReportByMonthList
            for (Map<String, Object> biReportByMonth : biReportByMonthList) {
                if (biReportByMonth.get("day").toString().equals(map.get("day"))) {
                    map.put("reportAmount", biReportByMonth.get("amount"));
                }
            }

            //循环biReportByMonthList
            for (Map<String, Object> biEntryByMonth : biEntryByMonthList) {
                if (biEntryByMonth.get("day").toString().equals(map.get("day"))) {
                    map.put("entryAmount", biEntryByMonth.get("amount"));
                }
            }

            list.add(map);
        }


        return list;
    }
}
