package com.jxjy.system.service.auth;

import com.jxjy.system.bean.auth.SelfUserEntity;
import com.jxjy.system.service.OrgService;
import com.jxjy.system.service.PersonService;
import com.jxjy.system.service.UserService;
import data.system.Org;
import data.system.Person;
import data.user.User;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.Objects;

@Slf4j
@Component
public class SelfUserDetailsService implements UserDetailsService {

    @Autowired
    private UserService userService;

    @Autowired
    private PersonService personService;

    @Autowired
    private OrgService orgService;

    /**
     * 查询用户信息
     * @param username
     * @return
     * @author wml
     * @date 2020/4/4
     **/
    @Override
    public SelfUserEntity loadUserByUsername(String username) throws UsernameNotFoundException {
        HttpServletRequest req = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        String wxType = req.getParameter("wxType");
        String loginType = req.getParameter("type");
        SelfUserEntity sysUserEntity = new SelfUserEntity();

        if(StringUtils.isNotBlank(wxType)&&wxType.equals("wx")){


            switch (loginType){
                case "person":
                    Person user = personService.getDetailsByLoginOpenId(username);
                    if (user == null) {
                        throw new UsernameNotFoundException("账号不存在");
                    }
                    sysUserEntity.setUsername(user.getOpenId());
                    sysUserEntity.setPassword("");
                    sysUserEntity.setUserId(user.getId());
                    sysUserEntity.setBaseCode(user.getBaseCode()== null ? "" : user.getBaseCode());
                    sysUserEntity.setName(user.getName());
                    sysUserEntity.setOpenId(user.getOpenId());
                    sysUserEntity.setType("person");
                    break;
                case "org":
                    Org org = orgService.getDetailsByLoginOpenId(username);
                    if (org == null) {
                        throw new UsernameNotFoundException("账号不存在");
                    }
                    sysUserEntity.setUsername(org.getOpenId());
                    sysUserEntity.setPassword("");
                    sysUserEntity.setUserId(org.getId());
                    sysUserEntity.setBaseCode(org.getBaseCode()== null ? "" : org.getBaseCode());
                    sysUserEntity.setName(org.getName());
                    sysUserEntity.setOpenId(org.getOpenId());
                    sysUserEntity.setType("org");
                    break;
                default:
                    break;

            }


        }else {
            User user = userService.getDetailsByLoginAccount(username);

            if (user == null) {
                throw new UsernameNotFoundException("账号不存在");
            }
            Object state = user.getState();
            if (!Objects.equals(state, "normal")) {
                // 账号被禁用
                log.error("登录失败, 账号被禁用, jsonObject={}", user);
                throw new LockedException("账号被禁用");
            }

            sysUserEntity.setUsername(user.getAccount());
            sysUserEntity.setPassword(user.getPassword());
            sysUserEntity.setUserId(user.getId());
            sysUserEntity.setBaseCode(user.getBaseCode()== null ? "" : user.getBaseCode());
            sysUserEntity.setName(user.getName());
            sysUserEntity.setType("admin");
        }
        return sysUserEntity;
    }


}