package com.jxjy.system.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import data.system.SignRecord;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

/**
 * @Author: wml
 * @Date 2025/5/9 10:21
 */
public interface SignRecordMapper extends BaseMapper<SignRecord> {

    @Select("<script>" +
            "SELECT count( 1 ) AS amount,r.city as city " +
            "FROM tb_recruit AS r " +
            "WHERE r.del = 0 " +
            "AND r.id IN ( SELECT sr.recruit_id FROM tb_sign_record AS sr WHERE sr.del = 0 AND sr.state = \"ON_BOARDING\" ) " +
            "GROUP BY r.city"+
            "</script>")
    List<Map<String, Object>> biCity();

    @Select("<script>" +
            "SELECT r.NAME as recruitName , r.times as amount" +
            ",(select COUNT(1) FROM tb_sign_record as sr WHERE sr.recruit_id = r.id AND sr.del = 0 AND sr.state = \"ON_BOARDING\") as entryAmount " +
            //",(select COUNT(1) FROM tb_sign_record as sr WHERE sr.recruit_id = r.id AND sr.del = 0 AND sr.state != \"ON_BOARDING\") as reportAmount " +
            "FROM tb_recruit AS r WHERE r.del = 0 AND `status` = \"up\" " +
            "</script>")
    List<Map<String, Object>> biRecruit();

    @Select("<script>" +
            "SELECT r.name AS recruit_name, " +
            "DATE_FORMAT(STR_TO_DATE(sr.update_time, '%Y-%m-%d %H:%i:%s'), '%Y-%m-%d') AS entry_date, COUNT(*) AS entry_count " +
            "FROM tb_sign_record sr INNER JOIN tb_recruit r ON sr.recruit_id = r.id WHERE sr.state = 'ON_BOARDING' " +
            "GROUP BY recruit_name, entry_date ORDER BY entry_date ASC, recruit_name ASC;" +
            "</script>")
    List<Map<String, Object>> biRecruitEntry();

    @Select("<script>" +
            "SELECT r.name AS recruit_name, " +
            "DATE_FORMAT(STR_TO_DATE(sr.create_time, '%Y-%m-%d %H:%i:%s'), '%Y-%m-%d') AS report_date, COUNT(*) AS report_count " +
            "FROM tb_sign_record sr INNER JOIN tb_recruit r ON sr.recruit_id = r.id " +
            "GROUP BY recruit_name, report_date ORDER BY report_date ASC, recruit_name ASC;" +
            "</script>")
    List<Map<String, Object>> biRecruitReport();

    @Select("<script>" +
            "SELECT LEFT(sr.update_time, 10) AS day, COUNT(*) AS amount " +
            "FROM tb_sign_record sr WHERE sr.state = 'ON_BOARDING' AND sr.update_time IS NOT NULL " +
            "AND sr.update_time LIKE CONCAT(DATE_FORMAT(NOW(), '%Y-%m'), '%') " +
            "GROUP BY day ORDER BY day ASC;" +
            "</script>")
    List<Map<String, Object>> biEntryByMonth();

    @Select("<script>" +
            "SELECT LEFT(sr.create_time, 10) AS day, COUNT(*) AS amount " +
            "FROM tb_sign_record sr WHERE sr.create_time IS NOT NULL " +
            "AND sr.create_time LIKE CONCAT(DATE_FORMAT(NOW(), '%Y-%m'), '%') " +
            "GROUP BY day ORDER BY day ASC;" +
            "</script>")
    List<Map<String, Object>> biReportByMonth();

    @Select("<script>" +
            "SELECT LEFT(sr.update_time, 7) AS day, COUNT(*) AS amount " +
            "FROM tb_sign_record sr WHERE sr.state = 'ON_BOARDING' AND sr.update_time IS NOT NULL " +
            "AND sr.update_time LIKE CONCAT(DATE_FORMAT(NOW(), '%Y'), '%') " +
            "GROUP BY day ORDER BY day ASC;" +
            "</script>")
    List<Map<String, Object>> biEntryByYear();

    @Select("<script>" +
            "SELECT LEFT(sr.create_time, 7) AS day, COUNT(*) AS amount " +
            "FROM tb_sign_record sr WHERE sr.create_time IS NOT NULL " +
            "AND sr.create_time LIKE CONCAT(DATE_FORMAT(NOW(), '%Y'), '%') " +
            "GROUP BY day ORDER BY day ASC;" +
            "</script>")
    List<Map<String, Object>> biReportByYear();

}
