package com.jxjy.system.controller;

import base.controller.BaseController;
import base.result.BaseResult;
import com.github.pagehelper.PageInfo;
import com.jxjy.system.bean.auth.UserContext;
import com.jxjy.system.service.SignRecordService;
import com.jxjy.system.service.RecruitService;
import com.jxjy.system.util.auth.UserUtils;
import data.system.SignRecord;
import data.system.Recruit;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author wangmenglong
 * @description: 报名管理
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/signRecord")
public class SignRecordController extends BaseController {

    @Resource
    SignRecordService signRecordService;

    @Resource
    RecruitService recruitService;

    /**
     * @description: 获取报名列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/l")
    public BaseResult list(HttpServletRequest req){
        PageInit(req);
        UserContext userContext = UserUtils.getUserContext();
        List<Recruit> list = recruitService.listBySignRecord(pageNum,pageSize,userContext.getUserId());
        PageInfo<Recruit> pageInfo = new PageInfo<Recruit>(list);
        return BaseResult.success(pageInfo);
    }

    /**
     * @description: 获取报名列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/admin/list")
    public BaseResult adminList(HttpServletRequest req){
        PageInit(req);
        String personPhoneNumber = req.getParameter("personPhoneNumber");
        String personIdno = req.getParameter("personIdno");
        String personName = req.getParameter("personName");
        String name = req.getParameter("name");
        String state = req.getParameter("state");
        String type = req.getParameter("type");
        List<Recruit> list = recruitService.listBySignRecordAdmin(pageNum,pageSize,personIdno,personName,name,personPhoneNumber,state,type);
        PageInfo<Recruit> pageInfo = new PageInfo<Recruit>(list);
        return BaseResult.success(pageInfo);
    }


    /**
    * @description: 新增报名
    * @author: wangmenglong
    * @param: [signRecord]
    * @return: base.result.BaseResult
    **/
    @PostMapping("/c")
    public BaseResult create(@RequestBody SignRecord signRecord){

        UserContext userContext = UserUtils.getUserContext();
        signRecord.setUserId(userContext.getUserId());
        signRecord.setPersonId(userContext.getUserId());
        signRecord.setBaseCode(userContext.getBaseCode());

        //判断是否重复
        if(signRecordService.isHave(signRecord.getRecruitId(),signRecord.getPersonId())){
            signRecordService.del(signRecord.getRecruitId(),signRecord.getPersonId());
        }else {
            signRecordService.create(signRecord);
        }
        return BaseResult.success("normal_001");
    }

    /**
     * @description: 是否报名
     * @author: wangmenglong
     * @param: [signRecord]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/have")
    public BaseResult have(@RequestBody SignRecord signRecord){

        UserContext userContext = UserUtils.getUserContext();
        signRecord.setUserId(userContext.getUserId());
        signRecord.setPersonId(userContext.getUserId());

        //判断是否重复
        if(signRecordService.isHave(signRecord.getRecruitId(),signRecord.getPersonId())){
            return BaseResult.success("normal_001","1");
        }else {
            return BaseResult.success("normal_001","0");
        }
    }

    /**
     * @description: 是否报名
     * @author: wangmenglong
     * @param: [signRecord]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/update/state")
    public BaseResult updateState(@RequestBody SignRecord signRecord){
        signRecordService.update(signRecord.getId(),signRecord.getState());
        return BaseResult.success("normal_001");
    }

}
