package com.jxjy.system.controller;

import base.controller.BaseController;
import base.result.BaseResult;
import com.github.pagehelper.PageInfo;
import com.jxjy.system.bean.auth.UserContext;
import com.jxjy.system.service.CollectService;
import com.jxjy.system.service.RecruitService;
import com.jxjy.system.util.auth.UserUtils;
import data.system.Collect;
import data.system.Recruit;
import data.system.SignRecord;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author wangmenglong
 * @description: 收藏管理
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/collect")
public class CollectController extends BaseController {

    @Resource
    CollectService collectService;

    @Resource
    RecruitService recruitService;

    /**
     * @description: 获取收藏列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/l")
    public BaseResult list(HttpServletRequest req){
        PageInit(req);
        UserContext userContext = UserUtils.getUserContext();
        List<Recruit> list = recruitService.listByCollect(pageNum,pageSize,userContext.getUserId());
        PageInfo<Recruit> pageInfo = new PageInfo<Recruit>(list);
        return BaseResult.success(pageInfo);
    }


    /**
    * @description: 新增收藏
    * @author: wangmenglong
    * @param: [collect]
    * @return: base.result.BaseResult
    **/
    @PostMapping("/c")
    public BaseResult create(@RequestBody Collect collect){

        UserContext userContext = UserUtils.getUserContext();
        collect.setUserId(userContext.getUserId());
        collect.setPersonId(userContext.getUserId());

        //判断是否重复
        if(collectService.isHave(collect.getRecruitId(),collect.getPersonId())){
            collectService.del(collect.getRecruitId(),collect.getPersonId());
        }else {
            collectService.create(collect);
        }
        return BaseResult.success("normal_001");
    }


    /**
     * @description: 是否收藏
     * @author: wangmenglong
     * @param: [signRecord]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/have")
    public BaseResult have(@RequestBody SignRecord signRecord){

        UserContext userContext = UserUtils.getUserContext();
        signRecord.setUserId(userContext.getUserId());
        signRecord.setPersonId(userContext.getUserId());

        //判断是否重复
        if(collectService.isHave(signRecord.getRecruitId(),signRecord.getPersonId())){
            return BaseResult.success("normal_001","1");
        }else {
            return BaseResult.success("normal_001","0");
        }
    }

}
