package com.jxjy.system.controller;

import base.controller.BaseController;
import base.result.BaseResult;
import com.jxjy.system.service.BiService;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * @author wangmenglong
 * @description: 统计管理
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/bi")
public class BiController extends BaseController {

    @Resource
    BiService biService;

    /**
     * @description: 左上角行政区员工统计
     **/
    @GetMapping("/biCity")
    public BaseResult biCity(){
        return BaseResult.success(biService.biCity());
    }

    /**
     * @description: 中间地图的人员籍贯统计
     **/
    @GetMapping("/biPersonProvince")
    public BaseResult biPersonProvince(){
        return BaseResult.success(biService.biPersonProvince());
    }

    /**
     * @description: 中间地图的企业籍贯统计
     **/
    @GetMapping("/biOrgProvince")
    public BaseResult biOrgProvince(){
        return BaseResult.success(biService.biOrgProvince());
    }

    /**
     * @description: 右边的达成率
     **/
    @GetMapping("/biRecruit")
    public BaseResult biRecruit(){
        return BaseResult.success(biService.biRecruit());
    }

    /**
     * @description: 入职统计
     **/
    @GetMapping("/biRecruitEntry")
    public BaseResult biRecruitEntry(){
        return BaseResult.success(biService.biRecruitEntry());
    }

    /**
     * @description: 报名统计
     **/
    @GetMapping("/biRecruitReport")
    public BaseResult biRecruitReport(){
        return BaseResult.success(biService.biRecruitReport());
    }


    /**
     * @description: 报名统计按照当前月份
     **/
    @GetMapping("/biRecruitLineByMonth")
    public BaseResult biRecruitLineByMonth(){
        return BaseResult.success(biService.biRecruitLineByMonth());
    }

    /**
     * @description: 报名统计按照当前年份
     **/
    @GetMapping("/biRecruitLineByYear")
    public BaseResult biRecruitLineByYear(){
        return BaseResult.success(biService.biRecruitLineByYear());
    }

}
