package data.system;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import data.parent.NameObj;
import lombok.Data;

/**
 * @author wangmenglong
 * @description: 报名记录
 * @date 2023/12/11 10:50
 */
@Data
@TableName(value = "tb_person")
public class Person extends NameObj {

    /**
     * 证件号码
     **/
    @TableField("id_no")
    private String idNo;

    /**
     * 手机号
     **/
    @TableField("phone_number")
    private String phoneNumber;

    /**
     * 报名时间
     **/
    @TableField("register_time")
    private String registerTime;

    /**
     * 年龄
     **/
    @TableField("age")
    private Integer age;

    /**
     * 性别
     **/
    @TableField("sex")
    private Boolean sex;

    /**
     * 民族
     **/
    @TableField("nation")
    private String nation;

    /**
     * 支付宝openid
     **/
    @TableField("open_id")
    private String openId;

    /**
     * 招聘类型
     **/
    @TableField("recruit_type_id")
    private String recruitTypeId;

    /**
     * 招聘类型
     **/
    @TableField("recruit_type")
    private String recruitType;

    /**
     * 教育经历
     **/
    @TableField("educational_background")
    private String educationalBackground;

    /**
     * 自我评价
     **/
    @TableField("self_evaluation")
    private String selfEvaluation;

    /**
     * 工作经历
     **/
    @TableField("work_experience")
    private String workExperience;

    /**
     * 报名状态
     **/
    @TableField(exist = false)
    private String recordState;

    /**
     * 头像
     **/
    @TableField("header_url")
    private String headerUrl;

    /**
     * 省
     **/
    @TableField("province")
    private String province;

    /**
     * 城市
     **/
    @TableField("city")
    private String city;

    /**
     * 区
     **/
    @TableField("region")
    private String region;
}
