package com.jxjy.system.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.jxjy.system.bean.auth.UserContext;
import com.jxjy.system.mapper.SchoolMapper;
import com.jxjy.system.service.SchoolService;
import com.jxjy.system.util.auth.UserUtils;
import com.jxjy.system.xsnowflake.SnowFlakeFactory;
import data.system.School;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 *
 * @return: 学校管理
 * @Author: wml
 * @Date 2025/5/9 10:22
 */
@Service
@Transactional
public class SchoolServiceImpl extends ServiceImpl<SchoolMapper, School> implements SchoolService {

    @Autowired
    SnowFlakeFactory snowFlakeFactory;


    /**
     * @description: 获取学校列表
     * @author: wangmenglong
     * @date; 2023/12/11 16:46
     * @param: [pageNum, pageSize]
     * @return: java.util.List<data.school.School>
     **/
    @Override
    public List<School> list(int pageNum, int pageSize, School school) {
        //启动分页工具
        PageHelper.startPage(pageNum, pageSize);
        //创建查询条件
        LambdaQueryWrapper<School> qw = new LambdaQueryWrapper<>();
        qw.like(StringUtils.isNotBlank(school.getName()),School::getName,school.getName())
                .eq(School::getDel,false)
                .eq(StringUtils.isNotBlank(school.getBaseCode()),School::getBaseCode, school.getBaseCode())
                .orderByDesc(School::getCreateTime);
        List<School> schoolList = super.list(qw);
        //返回查询结果
        return schoolList;
    }


    /**
     * @description: 获取学校列表
     * @author: wangmenglong
     * @date; 2023/12/11 16:46
     * @param: [pageNum, pageSize]
     * @return: java.util.List<data.school.School>
     **/
    @Override
    public List<School> listAll(School school) {
        //创建查询条件
        LambdaQueryWrapper<School> qw = new LambdaQueryWrapper<>();
        qw.like(StringUtils.isNotBlank(school.getName()),School::getName,school.getName())
                .eq(School::getDel,false)
                .eq(StringUtils.isNotBlank(school.getBaseCode()),School::getBaseCode, school.getBaseCode())
                .orderByDesc(School::getCreateTime);
        List<School> schoolList = super.list(qw);
        //返回查询结果
        return schoolList;
    }


    /**
     * @description: 新增学校
     * @author: wangmenglong
     * @date; 2023/12/11 16:51
     * @param: [school]
     * @return: boolean
     **/
    @Override
    public boolean create(School school) {

        UserContext userContext = UserUtils.getUserContext();
        String baseCode = userContext.getBaseCode();

        school.setId(snowFlakeFactory.nextId());
        school.setBaseCode(baseCode);
        school.setDel(false);
        school.setCreateTime(DateUtil.now());

        return super.save(school);
    }

    /**
     * @description: 编辑学校
     * @author: wangmenglong
     * @date; 2023/12/11 16:55
     * @param: [school]
     * @return: boolean
     **/
    @Override
    public boolean update(School school) {
        school.setUpdateTime(DateUtil.now());
        //判断是否传入id
        if(StringUtils.isBlank(school.getId())){
            return false;
        }
        return super.saveOrUpdate(school);
    }

    /**
     * @description: 删除学校
     * @author: wangmenglong
     * @date; 2023/12/11 17:06
     * @param: [id]
     * @return: boolean
     **/
    @Override
    public boolean del(String id) {
        if(StringUtils.isBlank(id)){
            return false;
        }
        LambdaUpdateWrapper<School> qw = new LambdaUpdateWrapper<>();
        qw.eq(School::getId,id)
                .set(School::getDel,true)
                .set(School::getDelTime, DateUtil.now());

        return super.update(qw);
    }


    /**
     * @author: wangmenglong
     * @date; 2024/3/24 17:19
     * @description: 获取学校详情
     * @param: [id]
     * @return: data.school.School
     **/
    @Override
    public School getDetails(String id) {
        return super.getById(id);
    }


    /**
     * @author: wangmenglong
     * @date; 2024/1/2 14:30
     * @description: 判断是否存在
     * @param: [account, id]
     * @return: boolean
     **/
    @Override
    public boolean isHave(String name, String id) {
        LambdaQueryWrapper<School> qw = new LambdaQueryWrapper<>();
        qw.eq(School::getDel,false)
                .eq(School::getName, name);
        //如果传了id就是编辑，编辑的时候要加个条件，不能把名字跟别人重复
        if(StringUtils.isNotBlank(id)){
            qw.ne(School::getId,id);
        }
        return super.count(qw)>0;
    }

}
