package com.jxjy.system.handler.auth;


import com.jxjy.system.bean.auth.SelfUserEntity;
import com.jxjy.system.util.auth.JWTTokenUtil;
import com.jxjy.system.util.auth.ResultUtil;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@Component
public class UserLoginSuccessHandler implements AuthenticationSuccessHandler {
    /**
     * 登录成功返回结果
     * @author wml
     * @date 2020/4/4
     * @param request
     * @param response
     * @param authentication
     * @return
     **/
    @Override
    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        // 组装JWT
        SelfUserEntity selfUserEntity =  (SelfUserEntity) authentication.getPrincipal();
        String token = JWTTokenUtil.createAccessToken(selfUserEntity);
        //token = JWTConfig.tokenPrefix + token;
        // 封装返回参数
        Map<String,Object> resultData = new HashMap<>();
        resultData.put("code","200");
        resultData.put("msg", "登录成功");
        resultData.put("token",token);
        resultData.put("name",selfUserEntity.getName());
        resultData.put("phone", selfUserEntity.getPhone());
        resultData.put("baseCode", selfUserEntity.getBaseCode());
        resultData.put("superAdmin", selfUserEntity.getSuperAdmin());

        ResultUtil.responseJson(response,resultData);
    }
}
