package com.jxjy.system.handler.auth;


import com.jxjy.system.util.auth.ResultUtil;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@Component
public class UserLoginFailureHandler implements AuthenticationFailureHandler {
    /**
     * 登录失败返回结果
     * @author wml
     * @date 2020/4/4
     * @param request
     * @param response
     * @param exception
     * @return
     **/
    @Override
    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException {
        // 这些对于操作的处理类可以根据不同异常进行不同处理
        if (exception instanceof UsernameNotFoundException){
            ResultUtil.responseJson(response,ResultUtil.resultCode(500,"账号不存在"));
        }
        if (exception instanceof LockedException){
            ResultUtil.responseJson(response,ResultUtil.resultCode(500,"账号被禁用"));
        }
        if (exception instanceof BadCredentialsException){
            ResultUtil.responseJson(response,ResultUtil.resultCode(500,exception.getMessage()));
        }

        ResultUtil.responseJson(response,ResultUtil.resultCode(500,"登录失败"));
    }
}
