package com.jxjy.system.controller;

import base.controller.BaseController;
import base.result.BaseResult;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.jxjy.system.bean.auth.UserContext;
import com.jxjy.system.service.SchoolService;
import com.jxjy.system.util.auth.UserUtils;
import data.system.School;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author wangmenglong
 * @description: 学校管理
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/school")
public class SchoolController extends BaseController {

    @Resource
    SchoolService schoolService;

    /**
     * @description: 获取学校列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/l")
    public BaseResult list(HttpServletRequest req,School school){
        PageInit(req);
        UserContext userContext = UserUtils.getUserContext();
        school.setBaseCode(userContext.getBaseCode());
        List<School> list = schoolService.list(pageNum,pageSize,school);
        PageInfo<School> pageInfo = new PageInfo<School>(list);
        return BaseResult.success(pageInfo);
    }

    /**
     * @description: 获取学校列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/l/all")
    public BaseResult listAll(HttpServletRequest req,School school){
        UserContext userContext = UserUtils.getUserContext();
        school.setBaseCode(userContext.getBaseCode());
        List<School> list = schoolService.list(pageNum,pageSize,school);
        return BaseResult.success(list);
    }


    /**
    * @description: 新增学校
    * @author: wangmenglong
    * @param: [school]
    * @return: base.result.BaseResult
    **/
    @PostMapping("/c")
    public BaseResult create(@RequestBody School school){
        //判断是否重复
        if(schoolService.isHave(school.getName(),school.getId())){
            return BaseResult.error("error_009");
        }
        return schoolService.create(school)?BaseResult.success("normal_001"):BaseResult.error("error_001");
    }

    /**
     * @description: 编辑学校
     * @author: wangmenglong
     * @param: [school]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/u")
    public BaseResult update(@RequestBody School school){
        //判断是否重复
        if(schoolService.isHave(school.getName(),school.getId())){
            return BaseResult.error("error_009");
        }
        return schoolService.update(school)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }

    /**
     * @description: 删除学校
     * @author: wangmenglong
     * @date; 2023/12/7 11:08
     * @param: [id]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/d")
    public BaseResult del(@RequestBody JSONObject jsonObject){
        String id = jsonObject.getString("id");
        return schoolService.del(id)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }

    /**
    * @author: wangmenglong
    * @date; 2024/3/24 17:18
    * @description: 获取学校详情
    * @param: [id]
    * @return: base.result.BaseResult
    **/
    @GetMapping("/details")
    public BaseResult details(@RequestParam("id")String id){
        School school = schoolService.getDetails(id);
        return BaseResult.success(school);
    }

}
