package com.jxjy.system.controller;

import base.controller.BaseController;
import base.result.BaseResult;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.jxjy.system.bean.auth.UserContext;
import com.jxjy.system.service.OrgService;
import com.jxjy.system.service.RecruitService;
import com.jxjy.system.util.auth.UserUtils;
import data.system.Org;
import data.system.Recruit;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author wangmenglong
 * @description: 招聘管理
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/recruit")
public class RecruitController extends BaseController {

    @Resource
    RecruitService recruitService;

    @Resource
    OrgService orgService;

    /**
     * @description: 获取招聘列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/l")
    public BaseResult list(HttpServletRequest req,Recruit recruit){
        PageInit(req);
        UserContext userContext = UserUtils.getUserContext();
        recruit.setBaseCode(userContext.getBaseCode());
        List<Recruit> list = recruitService.list(pageNum,pageSize,recruit);
        PageInfo<Recruit> pageInfo = new PageInfo<Recruit>(list);
        return BaseResult.success(pageInfo);
    }

    /**
     * @description: 获取招聘列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/l/my")
    public BaseResult listMy(HttpServletRequest req,Recruit recruit){
        PageInit(req);
        UserContext userContext = UserUtils.getUserContext();
        recruit.setBaseCode(userContext.getBaseCode());
        recruit.setUserId(userContext.getUserId());
        List<Recruit> list = recruitService.list(pageNum,pageSize,recruit);
        PageInfo<Recruit> pageInfo = new PageInfo<Recruit>(list);
        return BaseResult.success(pageInfo);
    }


    /**
    * @description: 新增招聘
    * @author: wangmenglong
    * @date; 2023/12/11 16:50
    * @param: [org]
    * @return: base.result.BaseResult
    **/
    @PostMapping("/c")
    public BaseResult create(@RequestBody Recruit recruit){

        UserContext userContext = UserUtils.getUserContext();
        if(!userContext.getType().equals("person")){
            Org org = orgService.getDetails(recruit.getOrgId());
            if(org==null||!org.getCheckStatus().equals("1")){
                return BaseResult.error("error_010");
            }
        }

        return recruitService.create(recruit)?BaseResult.success("normal_001"):BaseResult.error("error_001");
    }

    /**
     * @description: 编辑招聘
     * @author: wangmenglong
     * @date; 2023/12/7 11:05
     * @param: [org]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/u")
    public BaseResult update(@RequestBody Recruit recruit){

        UserContext userContext = UserUtils.getUserContext();
        if(!userContext.getType().equals("person")){
            Org org = orgService.getDetails(recruit.getOrgId());
            if(org==null||!org.getCheckStatus().equals("1")){
                return BaseResult.error("error_010");
            }
        }

        return recruitService.update(recruit)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }

    /**
     * @description: 删除招聘
     * @author: wangmenglong
     * @date; 2023/12/7 11:08
     * @param: [id]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/d")
    public BaseResult del(@RequestBody JSONObject jsonObject){
        String id = jsonObject.getString("id");
        return recruitService.del(id)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }

    /**
    * @author: wangmenglong
    * @date; 2024/3/24 17:18
    * @description: 获取招聘详情
    * @param: [id]
    * @return: base.result.BaseResult
    **/
    @GetMapping("/details")
    public BaseResult details(@RequestParam("id")String id){
        Recruit recruit = recruitService.getDetails(id);
        return BaseResult.success(recruit);
    }

    /**
     * @description: 编辑招聘
     * @author: wangmenglong
     * @date; 2023/12/7 11:05
     * @param: [org]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/u/status")
    public BaseResult updateStatus(@RequestBody Recruit recruit){

        recruit = recruitService.getDetails(recruit.getId());

        if(recruit.getCheckStatus().equals("0")&&recruit.getStatus().equals("down")){
            return BaseResult.error("error_011");
        }

        return recruitService.updateStatus(recruit)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }

    /**
     * @description: 编辑招聘
     * @author: wangmenglong
     * @date; 2023/12/7 11:05
     * @param: [org]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/check/status")
    public BaseResult checkStatus(@RequestBody Recruit recruit){
        return recruitService.checkStatus(recruit)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }
}
