package com.jxjy.system.controller;

import base.controller.BaseController;
import base.result.BaseResult;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.jxjy.system.bean.auth.UserContext;
import com.jxjy.system.service.OrgService;
import com.jxjy.system.util.auth.UserUtils;
import data.system.Org;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author wangmenglong
 * @description: 企业管理
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/org")
public class OrgController extends BaseController {

    @Resource
    OrgService orgService;

    /**
     * @description: 获取企业列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/l")
    public BaseResult list(HttpServletRequest req,Org org){
        PageInit(req);
        UserContext userContext = UserUtils.getUserContext();
        org.setBaseCode(userContext.getBaseCode());
        List<Org> list = orgService.list(pageNum,pageSize,org);
        PageInfo<Org> pageInfo = new PageInfo<Org>(list);
        return BaseResult.success(pageInfo);
    }


    /**
    * @description: 新增企业
    * @author: wangmenglong
    * @param: [org]
    * @return: base.result.BaseResult
    **/
    @PostMapping("/c")
    public BaseResult create(@RequestBody Org org){
        //判断是否重复
        if(orgService.isHave(org.getOpenId(),org.getId())){
            return BaseResult.error("error_004");
        }
        return orgService.create(org)?BaseResult.success("normal_001"):BaseResult.error("error_001");
    }

    /**
     * @description: 编辑企业
     * @author: wangmenglong
     * @param: [org]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/u")
    public BaseResult update(@RequestBody Org org){
        //判断是否重复
        if(orgService.isHave(org.getOpenId(),org.getId())){
            return BaseResult.error("error_004");
        }
        return orgService.update(org)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }

    /**
     * @description: 删除企业
     * @author: wangmenglong
     * @date; 2023/12/7 11:08
     * @param: [id]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/d")
    public BaseResult del(@RequestBody JSONObject jsonObject){
        String id = jsonObject.getString("id");
        return orgService.del(id)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }

    /**
    * @author: wangmenglong
    * @date; 2024/3/24 17:18
    * @description: 获取企业详情
    * @param: [id]
    * @return: base.result.BaseResult
    **/
    @GetMapping("/details")
    public BaseResult details(@RequestParam("id")String id){
        Org org = orgService.getDetails(id);
        return BaseResult.success(org);
    }

    /**
     * @author: wangmenglong
     * @date; 2024/3/24 17:18
     * @description: 获取企业详情
     * @param: [id]
     * @return: base.result.BaseResult
     **/
    @GetMapping("/details/my")
    public BaseResult detailsMy(){
        UserContext userContext = UserUtils.getUserContext();
        Org org = orgService.getDetails(userContext.getUserId());
        return BaseResult.success(org);
    }

    /**
     * @description: 编辑企业
     * @author: wangmenglong
     * @param: [org]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/check/state")
    public BaseResult checkState(@RequestBody Org org){
        return orgService.checkStatus(org)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }

}
