package com.jxjy.system.controller;

import base.controller.BaseController;
import base.result.BaseResult;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.jxjy.system.bean.auth.UserContext;
import com.jxjy.system.service.MessageRecordService;
import com.jxjy.system.util.auth.UserUtils;
import data.system.MessageRecord;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author wangmenglong
 * @description: 消息管理
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/message/record")
public class MessageRecordController extends BaseController {

    @Resource
    MessageRecordService messageRecordService;

    /**
     * @description: 获取消息列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/l")
    public BaseResult list(HttpServletRequest req,MessageRecord messageRecord){
        PageInit(req);
        UserContext userContext = UserUtils.getUserContext();
        messageRecord.setBaseCode(userContext.getBaseCode());
        List<MessageRecord> list = messageRecordService.list(pageNum,pageSize,messageRecord);
        PageInfo<MessageRecord> pageInfo = new PageInfo<MessageRecord>(list);
        return BaseResult.success(pageInfo);
    }

    /**
    * @author: wangmenglong
    * @date; 2024/3/24 17:18
    * @description: 获取消息详情
    * @param: [id]
    * @return: base.result.BaseResult
    **/
    @GetMapping("/details")
    public BaseResult details(@RequestParam("id")String id){
        MessageRecord messageRecord = messageRecordService.getDetails(id);
        return BaseResult.success(messageRecord);
    }

}
