package com.jxjy.system.util.weixin;

import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import org.springframework.data.redis.core.StringRedisTemplate;
import redis.RedisKey;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;

/**
 * 发送消息模块
 * @Author : wml
 * @Date: 2024-01-09 17:33
 */
public class TencentUtil {


    /**
     * 获取微信token
     * @return: base.result.BaseResult
     * @Author: wml
     * @Date 2023/12/13 16:05
     */
    public static String getToken(StringRedisTemplate stringRedisTemplate,String appId,String appSecret){

        if(stringRedisTemplate.hasKey(RedisKey.Wx_Token+":"+appId)){
            return stringRedisTemplate.opsForValue().get(RedisKey.Wx_Token+":"+appId);
        }

        HashMap<String, Object> requestParam = new HashMap<>();
        // appId
        requestParam.put("appid", appId);
        // 唯一凭证id appid:(换成自己的)
        requestParam.put("secret", appSecret);
        requestParam.put("grant_type", "client_credential");
        // 发送GET请求读取调用微信接口获取openid用户唯一标识
        String result = HttpUtil.get(WxApi.MESSAGE_ACCESS_TOKEN, requestParam);
        cn.hutool.json.JSONObject jsonObject = JSONUtil.parseObj(result);
        stringRedisTemplate.opsForValue().set(RedisKey.Wx_Token+":"+appId,jsonObject.getStr("access_token"));
        stringRedisTemplate.expire(RedisKey.Wx_Token+":"+appId,6500, TimeUnit.SECONDS);
        return  jsonObject.getStr("access_token");
    }

    /**
     * 获取微信短链
     * @return:
     * @Author: wml
     * @Date 2024/5/22 9:39
     */
    public static String queryUrlLink(StringRedisTemplate stringRedisTemplate,String appId,String appSecret){
        System.out.println("---------------------------微信消息发送--------------------------------");
        JSONObject body=new JSONObject();
        body.put("path","/pages/login/index");
        //发送
        String accessToken= getToken(stringRedisTemplate,appId,appSecret);
        System.out.println(body.toJSONString());
        String post =  HttpUtil.post(WxApi.GENERATE_URLLINK + accessToken, body.toJSONString());
        JSONObject jsonObject = JSONObject.parseObject(post);
        System.out.println(jsonObject.toJSONString());
        return jsonObject.getString("url_link");
    }


}
