package com.jxjy.system.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.jxjy.system.bean.auth.UserContext;
import com.jxjy.system.mapper.OrgMapper;
import com.jxjy.system.service.OrgService;
import com.jxjy.system.util.auth.UserUtils;
import com.jxjy.system.xsnowflake.SnowFlakeFactory;
import data.system.Org;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 *
 * @return: 企业管理
 * @Author: wml
 * @Date 2025/5/9 10:22
 */
@Service
@Transactional
public class OrgServiceImpl extends ServiceImpl<OrgMapper, Org> implements OrgService {

    @Autowired
    SnowFlakeFactory snowFlakeFactory;


    /**
     * @description: 获取企业列表
     * @author: wangmenglong
     * @date; 2023/12/11 16:46
     * @param: [pageNum, pageSize]
     * @return: java.util.List<data.org.Org>
     **/
    @Override
    public List<Org> list(int pageNum, int pageSize, Org org) {
        //启动分页工具
        PageHelper.startPage(pageNum, pageSize);
        //创建查询条件
        LambdaQueryWrapper<Org> qw = new LambdaQueryWrapper<>();
        qw.like(StringUtils.isNotBlank(org.getName()),Org::getName,org.getName())
                .eq(Org::getDel,false)
                .eq(StringUtils.isNotBlank(org.getBaseCode()),Org::getBaseCode, org.getBaseCode())
                .orderByDesc(Org::getCreateTime);
        List<Org> orgList = super.list(qw);
        //返回查询结果
        return orgList;
    }


    /**
     * @description: 新增企业
     * @author: wangmenglong
     * @date; 2023/12/11 16:51
     * @param: [org]
     * @return: boolean
     **/
    @Override
    public boolean create(Org org) {

        UserContext userContext = UserUtils.getUserContext();
        String baseCode = userContext.getBaseCode();

        org.setId(snowFlakeFactory.nextId());
        org.setBaseCode(baseCode);
        org.setDel(false);
        org.setCreateTime(DateUtil.now());

        return super.save(org);
    }

    /**
     * @description: 编辑企业
     * @author: wangmenglong
     * @date; 2023/12/11 16:55
     * @param: [org]
     * @return: boolean
     **/
    @Override
    public boolean update(Org org) {
        org.setUpdateTime(DateUtil.now());
        //判断是否传入id
        if(StringUtils.isBlank(org.getId())){
            return false;
        }
        return super.saveOrUpdate(org);
    }

    /**
     * @description: 删除企业
     * @author: wangmenglong
     * @date; 2023/12/11 17:06
     * @param: [id]
     * @return: boolean
     **/
    @Override
    public boolean del(String id) {
        if(StringUtils.isBlank(id)){
            return false;
        }
        LambdaUpdateWrapper<Org> qw = new LambdaUpdateWrapper<>();
        qw.eq(Org::getId,id)
                .set(Org::getDel,true)
                .set(Org::getDelTime, DateUtil.now());

        return super.update(qw);
    }


    /**
     * @author: wangmenglong
     * @date; 2024/3/24 17:19
     * @description: 获取企业详情
     * @param: [id]
     * @return: data.org.Org
     **/
    @Override
    public Org getDetails(String id) {
        return super.getById(id);
    }


    /**
     * @author: wangmenglong
     * @date; 2024/1/2 14:30
     * @description: 判断是否存在
     * @param: [account, id]
     * @return: boolean
     **/
    @Override
    public boolean isHave(String name, String id) {
        LambdaQueryWrapper<Org> qw = new LambdaQueryWrapper<>();
        qw.eq(Org::getDel,false)
                .eq(Org::getName, name);
        //如果传了id就是编辑，编辑的时候要加个条件，不能把名字跟别人重复
        if(StringUtils.isNotBlank(id)){
            qw.ne(Org::getId,id);
        }
        return super.count(qw)>0;
    }

}
