package com.jxjy.system.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxjy.system.mapper.HigherSchoolRecordMapper;
import com.jxjy.system.service.HigherSchoolRecordService;
import com.jxjy.system.xsnowflake.SnowFlakeFactory;
import data.system.HigherSchoolRecord;
import data.system.SignRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 *
 * @return: 报名管理
 * @Author: wml
 * @Date 2025/5/9 10:22
 */
@Service
@Transactional
public class HigherSchoolRecordServiceImpl extends ServiceImpl<HigherSchoolRecordMapper, HigherSchoolRecord> implements HigherSchoolRecordService {

    @Autowired
    SnowFlakeFactory snowFlakeFactory;

    /**
     * @description: 新增报名
     * @author: wangmenglong
     * @date; 2023/12/11 16:51
     * @param: [higherSchoolRecord]
     * @return: boolean
     **/
    @Override
    public String create(HigherSchoolRecord higherSchoolRecord) {

        higherSchoolRecord.setId(snowFlakeFactory.nextId());
        higherSchoolRecord.setDel(false);
        higherSchoolRecord.setCreateTime(DateUtil.now());
        higherSchoolRecord.setState("new");
        super.save(higherSchoolRecord);
        return higherSchoolRecord.getId();
    }


    /**
     * @description: 删除报名
     * @author: wangmenglong
     * @date; 2023/12/11 17:06
     * @param: [id]
     * @return: boolean
     **/
    @Override
    public boolean del(String personId) {
        if(StringUtils.isBlank(personId)){
            return false;
        }
        LambdaUpdateWrapper<HigherSchoolRecord> qw = new LambdaUpdateWrapper<>();
        qw.eq(HigherSchoolRecord::getPersonId,personId)
                .set(HigherSchoolRecord::getDel,true)
                .set(HigherSchoolRecord::getDelTime, DateUtil.now());

        return super.update(qw);
    }


    /**
     * @author: wangmenglong
     * @date; 2024/1/2 14:30
     * @description: 判断是否存在
     * @param: [account, id]
     * @return: boolean
     **/
    @Override
    public boolean isHave(String personId) {
        LambdaQueryWrapper<HigherSchoolRecord> qw = new LambdaQueryWrapper<>();
        qw.eq(HigherSchoolRecord::getDel,false)
                .eq(HigherSchoolRecord::getPersonId, personId);
        return super.count(qw)>0;
    }

    /**
     * @author: wangmenglong
     * @date; 2024/1/2 14:30
     * @description: 修改状态
     * @param: [account, id]
     * @return: boolean
     **/
    @Override
    public boolean updateState(String id) {
        LambdaUpdateWrapper<HigherSchoolRecord> qw = new LambdaUpdateWrapper<>();
        qw.eq(HigherSchoolRecord::getDel,false)
                .eq(HigherSchoolRecord::getUserId, id)
                .set(HigherSchoolRecord::getState, "revisit");
        return super.update(qw);
    }

    /**
     * @author: wangmenglong
     * @date; 2024/1/2 14:30
     * @description: 修改状态
     * @param: [account, id]
     * @return: boolean
     **/
    @Override
    public HigherSchoolRecord detailsByPersonId(String personId) {

        //根据人员id查出来最后一条数据
        LambdaQueryWrapper<HigherSchoolRecord> qw = new LambdaQueryWrapper<>();
        qw.eq(HigherSchoolRecord::getDel,false)
                .eq(HigherSchoolRecord::getPersonId, personId)
                .orderByDesc(HigherSchoolRecord::getCreateTime)
                .last("limit 1");

        return super.getOne(qw);
    }

}
