package com.jxjy.system.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxjy.system.mapper.DriverSchoolRecordMapper;
import com.jxjy.system.service.DriverSchoolRecordService;
import com.jxjy.system.xsnowflake.SnowFlakeFactory;
import data.system.DriverSchoolRecord;
import data.system.HigherSchoolRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 *
 * @return: 报名管理
 * @Author: wml
 * @Date 2025/5/9 10:22
 */
@Service
@Transactional
public class DriverSchoolRecordServiceImpl extends ServiceImpl<DriverSchoolRecordMapper, DriverSchoolRecord> implements DriverSchoolRecordService {

    @Autowired
    SnowFlakeFactory snowFlakeFactory;

    /**
     * @description: 新增报名
     * @author: wangmenglong
     * @date; 2023/12/11 16:51
     * @param: [driverSchoolRecord]
     * @return: boolean
     **/
    @Override
    public String create(DriverSchoolRecord driverSchoolRecord) {

        driverSchoolRecord.setId(snowFlakeFactory.nextId());
        driverSchoolRecord.setDel(false);
        driverSchoolRecord.setCreateTime(DateUtil.now());
        driverSchoolRecord.setState("new");
        super.save(driverSchoolRecord);
        return driverSchoolRecord.getId();
    }


    /**
     * @description: 删除报名
     * @author: wangmenglong
     * @date; 2023/12/11 17:06
     * @param: [id]
     * @return: boolean
     **/
    @Override
    public boolean del(String personId) {
        if(StringUtils.isBlank(personId)){
            return false;
        }
        LambdaUpdateWrapper<DriverSchoolRecord> qw = new LambdaUpdateWrapper<>();
        qw.eq(DriverSchoolRecord::getPersonId,personId)
                .set(DriverSchoolRecord::getDel,true)
                .set(DriverSchoolRecord::getDelTime, DateUtil.now());

        return super.update(qw);
    }


    /**
     * @author: wangmenglong
     * @date; 2024/1/2 14:30
     * @description: 判断是否存在
     * @param: [account, id]
     * @return: boolean
     **/
    @Override
    public boolean isHave(String personId) {
        LambdaQueryWrapper<DriverSchoolRecord> qw = new LambdaQueryWrapper<>();
        qw.eq(DriverSchoolRecord::getDel,false)
                .eq(DriverSchoolRecord::getPersonId, personId);
        return super.count(qw)>0;
    }

    /**
     * @author: wangmenglong
     * @date; 2024/1/2 14:30
     * @description: 修改状态
     * @param: [account, id]
     * @return: boolean
     **/
    @Override
    public boolean updateState(String id) {
        LambdaUpdateWrapper<DriverSchoolRecord> qw = new LambdaUpdateWrapper<>();
        qw.eq(DriverSchoolRecord::getDel,false)
                .eq(DriverSchoolRecord::getUserId, id)
                .set(DriverSchoolRecord::getState, "revisit");
        return super.update(qw);
    }

    /**
     * @author: wangmenglong
     * @date; 2024/1/2 14:30
     * @description: 修改状态
     * @param: [account, id]
     * @return: boolean
     **/
    @Override
    public DriverSchoolRecord detailsByPersonId(String personId) {

        //根据人员id查出来最后一条数据
        LambdaQueryWrapper<DriverSchoolRecord> qw = new LambdaQueryWrapper<>();
        qw.eq(DriverSchoolRecord::getDel,false)
                .eq(DriverSchoolRecord::getPersonId, personId)
                .orderByDesc(DriverSchoolRecord::getCreateTime)
                .last("limit 1");

        return super.getOne(qw);
    }
}
