package com.jxjy.system.controller;

import base.controller.BaseController;
import base.result.BaseResult;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.jxjy.system.bean.auth.UserContext;
import com.jxjy.system.service.WorkExperienceService;
import com.jxjy.system.util.auth.UserUtils;
import data.system.WorkExperience;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author wangmenglong
 * @description: 工作经历管理
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/workExperience")
public class WorkExperienceController extends BaseController {

    @Resource
    WorkExperienceService workExperienceService;

    /**
     * @description: 获取工作经历列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/l")
    public BaseResult list(HttpServletRequest req,WorkExperience workExperience){
        PageInit(req);
        UserContext userContext = UserUtils.getUserContext();
        workExperience.setBaseCode(userContext.getBaseCode());
        List<WorkExperience> list = workExperienceService.list(pageNum,pageSize,workExperience);
        PageInfo<WorkExperience> pageInfo = new PageInfo<WorkExperience>(list);
        return BaseResult.success(pageInfo);
    }


    /**
    * @description: 新增工作经历
    * @author: wangmenglong
    * @param: [workExperience]
    * @return: base.result.BaseResult
    **/
    @PostMapping("/c")
    public BaseResult create(@RequestBody WorkExperience workExperience){
        //判断是否重复
        if(workExperienceService.isHave(workExperience.getOrgName(),workExperience.getId())){
            return BaseResult.error("error_004");
        }
        return workExperienceService.create(workExperience)?BaseResult.success("normal_001"):BaseResult.error("error_001");
    }

    /**
     * @description: 编辑工作经历
     * @author: wangmenglong
     * @param: [workExperience]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/u")
    public BaseResult update(@RequestBody WorkExperience workExperience){
        //判断是否重复
        if(workExperienceService.isHave(workExperience.getOrgName(),workExperience.getId())){
            return BaseResult.error("error_004");
        }
        return workExperienceService.update(workExperience)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }

    /**
     * @description: 删除工作经历
     * @author: wangmenglong
     * @date; 2023/12/7 11:08
     * @param: [id]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/d")
    public BaseResult del(@RequestBody JSONObject jsonObject){
        String id = jsonObject.getString("id");
        return workExperienceService.del(id)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }

    /**
    * @author: wangmenglong
    * @date; 2024/3/24 17:18
    * @description: 获取工作经历详情
    * @param: [id]
    * @return: base.result.BaseResult
    **/
    @GetMapping("/details")
    public BaseResult details(@RequestParam("id")String id){
        WorkExperience workExperience = workExperienceService.getDetails(id);
        return BaseResult.success(workExperience);
    }

}
