package com.jxjy.system.controller;

import base.controller.BaseController;
import base.result.BaseResult;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.jxjy.system.bean.auth.UserContext;
import com.jxjy.system.service.MessageService;
import com.jxjy.system.util.auth.UserUtils;
import data.system.Message;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author wangmenglong
 * @description: 消息管理
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/message")
public class MessageController extends BaseController {

    @Resource
    MessageService messageService;

    /**
     * @description: 获取消息列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/l")
    public BaseResult list(HttpServletRequest req,Message message){
        PageInit(req);
        UserContext userContext = UserUtils.getUserContext();
        message.setBaseCode(userContext.getBaseCode());
        List<Message> list = messageService.list(pageNum,pageSize,message);
        PageInfo<Message> pageInfo = new PageInfo<Message>(list);
        return BaseResult.success(pageInfo);
    }


    /**
    * @description: 新增消息
    * @author: wangmenglong
    * @param: [message]
    * @return: base.result.BaseResult
    **/
    @PostMapping("/c")
    public BaseResult create(@RequestBody Message message){
        return messageService.create(message)?BaseResult.success("normal_001"):BaseResult.error("error_001");
    }

    /**
     * @description: 编辑消息
     * @author: wangmenglong
     * @param: [message]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/u")
    public BaseResult update(@RequestBody Message message){
        return messageService.update(message)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }

    /**
     * @description: 删除消息
     * @author: wangmenglong
     * @date; 2023/12/7 11:08
     * @param: [id]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/d")
    public BaseResult del(@RequestBody JSONObject jsonObject){
        String id = jsonObject.getString("id");
        return messageService.del(id)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }

    /**
    * @author: wangmenglong
    * @date; 2024/3/24 17:18
    * @description: 获取消息详情
    * @param: [id]
    * @return: base.result.BaseResult
    **/
    @GetMapping("/details")
    public BaseResult details(@RequestParam("id")String id){
        Message message = messageService.getDetails(id);
        return BaseResult.success(message);
    }

}
