package com.jxjy.system.controller;

import base.controller.BaseController;
import base.result.BaseResult;
import com.github.pagehelper.PageInfo;
import com.jxjy.system.bean.auth.UserContext;
import com.jxjy.system.service.PersonService;
import com.jxjy.system.service.RecruitService;
import com.jxjy.system.service.HigherSchoolRecordService;
import com.jxjy.system.util.auth.UserUtils;
import data.system.Person;
import data.system.Recruit;
import data.system.HigherSchoolRecord;
import data.system.SignRecord;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author wangmenglong
 * @description: 报名管理
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/higherSchool/record")
public class HigherSchoolRecordController extends BaseController {

    @Resource
    HigherSchoolRecordService higherSchoolRecordService;

    @Resource
    PersonService personService;

    /**
     * @description: 获取报名列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/l")
    public BaseResult list(HttpServletRequest req, Person person){
        PageInit(req);
        UserContext userContext = UserUtils.getUserContext();
        List<Person> list = personService.listHigher(pageNum,pageSize,person);
        PageInfo<Person> pageInfo = new PageInfo<Person>(list);
        return BaseResult.success(pageInfo);
    }


    /**
    * @description: 新增报名
    * @author: wangmenglong
    * @param: [higherSchoolRecord]
    * @return: base.result.BaseResult
    **/
    @PostMapping("/c")
    public BaseResult create(@RequestBody HigherSchoolRecord higherSchoolRecord){

        UserContext userContext = UserUtils.getUserContext();
        higherSchoolRecord.setUserId(userContext.getUserId());
        higherSchoolRecord.setPersonId(userContext.getUserId());
        higherSchoolRecord.setBaseCode(userContext.getBaseCode());

        //判断是否重复
        if(higherSchoolRecordService.isHave(higherSchoolRecord.getPersonId())){
            higherSchoolRecordService.del(higherSchoolRecord.getPersonId());
        }else {
            higherSchoolRecordService.create(higherSchoolRecord);
        }
        return BaseResult.success("normal_001");
    }

    /**
     * @description: 是否报名
     * @author: wangmenglong
     * @param: [higherSchoolRecord]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/have")
    public BaseResult have(@RequestBody HigherSchoolRecord higherSchoolRecord){

        UserContext userContext = UserUtils.getUserContext();
        higherSchoolRecord.setUserId(userContext.getUserId());
        higherSchoolRecord.setPersonId(userContext.getUserId());

        //判断是否重复
        if(higherSchoolRecordService.isHave(higherSchoolRecord.getPersonId())){
            return BaseResult.success("normal_001","1");
        }else {
            return BaseResult.success("normal_001","0");
        }
    }

    /**
     * @description: 是否报名
     * @author: wangmenglong
     * @param: [signRecord]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/update/state")
    public BaseResult updateState(@RequestBody SignRecord signRecord){
        higherSchoolRecordService.updateState(signRecord.getId());
        return BaseResult.success("normal_001");
    }
}
