package com.jxjy.system.controller;

import base.controller.BaseController;
import base.result.BaseResult;
import com.github.pagehelper.PageInfo;
import com.jxjy.system.bean.auth.UserContext;
import com.jxjy.system.service.DriverSchoolRecordService;
import com.jxjy.system.service.PersonService;
import com.jxjy.system.service.RecruitService;
import com.jxjy.system.util.auth.UserUtils;
import data.system.DriverSchoolRecord;
import data.system.Person;
import data.system.Recruit;
import data.system.SignRecord;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author wangmenglong
 * @description: 报名管理
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/driverSchool/record")
public class DriverSchoolRecordController extends BaseController {

    @Resource
    DriverSchoolRecordService driverSchoolRecordService;

    @Resource
    PersonService personService;

    /**
     * @description: 获取报名列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/l")
    public BaseResult list(HttpServletRequest req, Person  person){
        PageInit(req);
        UserContext userContext = UserUtils.getUserContext();
        List<Person> list = personService.listDriver(pageNum,pageSize,person);
        PageInfo<Person> pageInfo = new PageInfo<Person>(list);
        return BaseResult.success(pageInfo);
    }


    /**
    * @description: 新增报名
    * @author: wangmenglong
    * @param: [driverSchoolRecord]
    * @return: base.result.BaseResult
    **/
    @PostMapping("/c")
    public BaseResult create(@RequestBody DriverSchoolRecord driverSchoolRecord){

        UserContext userContext = UserUtils.getUserContext();
        driverSchoolRecord.setUserId(userContext.getUserId());
        driverSchoolRecord.setPersonId(userContext.getUserId());
        driverSchoolRecord.setBaseCode(userContext.getBaseCode());

        //判断是否重复
        if(driverSchoolRecordService.isHave(driverSchoolRecord.getPersonId())){
            driverSchoolRecordService.del(driverSchoolRecord.getPersonId());
        }else {
            driverSchoolRecordService.create(driverSchoolRecord);
        }
        return BaseResult.success("normal_001");
    }

    /**
     * @description: 是否报名
     * @author: wangmenglong
     * @param: [driverSchoolRecord]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/have")
    public BaseResult have(@RequestBody DriverSchoolRecord driverSchoolRecord){

        UserContext userContext = UserUtils.getUserContext();
        driverSchoolRecord.setUserId(userContext.getUserId());
        driverSchoolRecord.setPersonId(userContext.getUserId());

        //判断是否重复
        if(driverSchoolRecordService.isHave(driverSchoolRecord.getPersonId())){
            return BaseResult.success("normal_001","1");
        }else {
            return BaseResult.success("normal_001","0");
        }
    }

    /**
     * @description: 是否报名
     * @author: wangmenglong
     * @param: [signRecord]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/update/state")
    public BaseResult updateState(@RequestBody SignRecord signRecord){
        driverSchoolRecordService.updateState(signRecord.getId());
        return BaseResult.success("normal_001");
    }
}
