package com.jxjy.system;

//import org.mybatis.spring.annotation.MapperScan;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.scheduling.annotation.EnableScheduling;

@RefreshScope
@EnableDiscoveryClient
@SpringBootApplication(scanBasePackages = {"com.jxjy.system"})
@MapperScan(basePackages = "com.jxjy.system.mapper")
@EnableCaching  // 开启缓存
@EnableScheduling
public class jxjySystemApplication {

    public static void main(String[] args) {
        SpringApplication.run(jxjySystemApplication.class, args);
    }

}
