package com.jxjy.system.util.weixin;

import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import org.springframework.data.redis.core.StringRedisTemplate;
import redis.RedisKey;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;

/**
 * 发送消息模块
 * @Author : wml
 * @Date: 2024-01-09 17:33
 */
public class TencentMessageUtil {


    /**
     * 获取微信token
     * @return: base.result.BaseResult
     * @Author: wml
     * @Date 2023/12/13 16:05
     */
    public static String getToken(StringRedisTemplate stringRedisTemplate,String appId,String appSecret){

        if(stringRedisTemplate.hasKey(RedisKey.WX_MESSAGE_TOKEN+":"+appId)){
            return stringRedisTemplate.opsForValue().get(RedisKey.WX_MESSAGE_TOKEN+":"+appId);
        }

        HashMap<String, Object> requestParam = new HashMap<>();
        // appId
        requestParam.put("appid", appId);
        // 唯一凭证id appid:(换成自己的)
        requestParam.put("secret", appSecret);
        requestParam.put("grant_type", "client_credential");
        // 发送GET请求读取调用微信接口获取openid用户唯一标识
        String result = HttpUtil.get(WxApi.MESSAGE_ACCESS_TOKEN, requestParam);
        cn.hutool.json.JSONObject jsonObject = JSONUtil.parseObj(result);
        stringRedisTemplate.opsForValue().set(RedisKey.WX_MESSAGE_TOKEN+":"+appId,jsonObject.getStr("access_token"));
        stringRedisTemplate.expire(RedisKey.WX_MESSAGE_TOKEN+":"+appId,6500, TimeUnit.SECONDS);
        return  jsonObject.getStr("access_token");
    }

    /**
     * 发送微信消息
     * @return:
     * @Author: wml
     * @Date 2024/5/22 9:39
     */
    public static JSONObject send(StringRedisTemplate stringRedisTemplate,String appId,String appSecret,String templateId,String page,String messageMiniprogram,String openId,JSONObject json){
        System.out.println("---------------------------微信消息发送--------------------------------");
        JSONObject body=new JSONObject();
        body.put("touser",openId);
        body.put("template_id",templateId);
        body.put("page",page);
        body.put("miniprogram_state",messageMiniprogram);
        body.put("lang","zh_CN");
        /*JSONObject json=new JSONObject();
        json.put("thing6",JSONObject.parseObject("{'value':'未读消息提醒'}"));
        json.put("thing2",JSONObject.parseObject("{'value':'"+data.getString("content")+"'}"));
        json.put("time9",JSONObject.parseObject("{'value':'"+data.getString("createTime")+"'}"));
        json.put("thing5",JSONObject.parseObject("{'value':'点击查看详情'}"));*/
        body.put("data",json);
        //发送
        String accessToken= getToken(stringRedisTemplate,appId,appSecret);
        System.out.println(body.toJSONString());
        String post =  HttpUtil.post(WxApi.MESSAGE_SEND + accessToken, body.toJSONString());
        JSONObject jsonObject = JSONObject.parseObject(post);
        System.out.println(jsonObject.toJSONString());

        return jsonObject;
    }

    public static void addMessageNumber(StringRedisTemplate stringRedisTemplate,String templateId, String openId,int number) {

        //如果有key直接操作+-
        if(!stringRedisTemplate.opsForHash().hasKey(RedisKey.TENCENT_MESSAGE_NUMBER,openId+"_"+templateId)){
            stringRedisTemplate.opsForHash().increment(RedisKey.TENCENT_MESSAGE_NUMBER,openId+"_"+templateId,0);
        }

        //操作数量
        stringRedisTemplate.opsForHash().increment(RedisKey.TENCENT_MESSAGE_NUMBER,openId+"_"+templateId,number);

        //小于0就等于0
        if(stringRedisTemplate.opsForHash().hasKey(RedisKey.TENCENT_MESSAGE_NUMBER,openId+"_"+templateId)&&
                Integer.parseInt(
                        stringRedisTemplate.opsForHash().get(RedisKey.TENCENT_MESSAGE_NUMBER,openId+"_"+templateId
                        ).toString())+number<0){
            stringRedisTemplate.opsForHash().put(RedisKey.TENCENT_MESSAGE_NUMBER,openId+"_"+templateId,"0");
        }

    }

    /**
     * 发送客服消息
     * @return: com.alibaba.fastjson.JSONObject
     * @Author: wml
     * @Date 2024/5/22 9:39
     */
    public JSONObject sendkefu(){
        JSONObject body=new JSONObject();
        body.put("touser","o3PCm6_qFaQmZb13EujI9T5xLI7I");
        body.put("msgtype","text");
        body.put("miniprogram_state","trial");
        body.put("lang","zh_CN");
        JSONObject json=new JSONObject();
        json.put("content","工资单有更新，请及时查询");
        body.put("text",json);
        //发送
        String accessToken= getToken(null,"","");
        System.out.println(body.toJSONString());
        String post =  HttpUtil.post("https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=" + accessToken, body.toJSONString());
        JSONObject jsonObject = JSONObject.parseObject(post);
        System.out.println(jsonObject.toJSONString());

        return jsonObject;
    }

}
