package com.jxjy.system.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.jxjy.system.bean.auth.UserContext;
import com.jxjy.system.mapper.ArticleMapper;
import com.jxjy.system.service.ArticleService;
import com.jxjy.system.util.auth.UserUtils;
import com.jxjy.system.xsnowflake.SnowFlakeFactory;
import data.system.Article;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 *
 * @return: 文章管理
 * @Author: wml
 * @Date 2025/5/9 10:22
 */
@Service
@Transactional
public class ArticleServiceImpl extends ServiceImpl<ArticleMapper, Article> implements ArticleService {

    @Autowired
    SnowFlakeFactory snowFlakeFactory;


    /**
     * @description: 获取文章列表
     * @author: wangmenglong
     * @date; 2023/12/11 16:46
     * @param: [pageNum, pageSize]
     * @return: java.util.List<data.article.Article>
     **/
    @Override
    public List<Article> list(int pageNum, int pageSize, Article article) {
        //启动分页工具
        PageHelper.startPage(pageNum, pageSize);
        //创建查询条件
        LambdaQueryWrapper<Article> qw = new LambdaQueryWrapper<>();
        qw.like(StringUtils.isNotBlank(article.getTitle()),Article::getTitle,article.getTitle())
                .eq(StringUtils.isNotBlank(article.getType()), Article::getType,article.getType())
                .eq(null!=article.getRelease(), Article::getRelease,article.getRelease())
                .eq(null!=article.getCaseType(), Article::getCaseType,article.getCaseType())
                .eq(Article::getDel,false)
                .orderByDesc(Article::getCreateTime);
        List<Article> articleList = super.list(qw);
        //返回查询结果
        return articleList;
    }


    /**
     * @description: 新增文章
     * @author: wangmenglong
     * @date; 2023/12/11 16:51
     * @param: [article]
     * @return: boolean
     **/
    @Override
    public boolean create(Article article) {

        UserContext userContext = UserUtils.getUserContext();
        String baseCode = userContext.getBaseCode();

        article.setId(snowFlakeFactory.nextId());
        article.setBaseCode(baseCode);
        article.setUserId(userContext.getUserId());
        article.setUserName(userContext.getUsername());
        article.setDel(false);
        article.setCreateTime(DateUtil.now());
        article.setRelease(false);

        return super.save(article);
    }

    /**
     * @description: 编辑文章
     * @author: wangmenglong
     * @date; 2023/12/11 16:55
     * @param: [org]
     * @return: boolean
     **/
    @Override
    public boolean update(Article article) {
        article.setUpdateTime(DateUtil.now());
        //判断是否传入id
        if(StringUtils.isBlank(article.getId())){
            return false;
        }
        return super.saveOrUpdate(article);
    }

    /**
     * @description: 修改状态
     * @author: wangmenglong
     * @date; 2023/12/11 17:04
     * @param: [id, state]
     * @return: boolean
     **/
    @Override
    public boolean uState(String id, String state) {
        if(StringUtils.isBlank(id)){
            return false;
        }
        Article article = super.getById(id);
        if(null!=article.getRelease()&&article.getRelease()){
            article.setRelease(false);
        }else {
            article.setRelease(true);
        }
        article.setUpdateTime(DateUtil.now());
        return super.saveOrUpdate(article);
    }


    /**
     * @description: 删除文章
     * @author: wangmenglong
     * @date; 2023/12/11 17:06
     * @param: [id]
     * @return: boolean
     **/
    @Override
    public boolean del(String id) {
        if(StringUtils.isBlank(id)){
            return false;
        }
        LambdaUpdateWrapper<Article> qw = new LambdaUpdateWrapper<>();
        qw.eq(Article::getId,id)
                .set(Article::getDel,true)
                .set(Article::getDelTime, DateUtil.now());

        return super.update(qw);
    }


    /**
     * @author: wangmenglong
     * @date; 2024/3/24 17:19
     * @description: 获取文章详情
     * @param: [id]
     * @return: data.article.Article
     **/
    @Override
    public Article getDetails(String id) {
        return super.getById(id);
    }

}
