package com.jxjy.system.controller.api;

import base.controller.BaseController;
import base.result.BaseResult;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.jxjy.system.util.weixin.TencentMessageUtil;
import com.jxjy.system.util.weixin.WxApi;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.*;
import redis.RedisKey;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.HashMap;

/**
 * @author wangmenglong
 * @description: 微信登录管理
 * @date 2025/09/23 11:35
 */
@RestController
@RequestMapping("/public/wx")
public class ApiWxController extends BaseController {


    @Value("${weixin.appid}")
    public String appId;

    @Value("${weixin.secret}")
    public String appSecret;

    @Value("${weixin.openIdUrl}")
    public String openIdUrl;

    @Resource
    StringRedisTemplate stringRedisTemplate;


    /**
     * @author: wangmenglong
     * @date; 2024/1/25 11:04
     * @description: 获取个人openid
     * @param: [code]
     * @return: com.mytrack.base.result.BaseResult
     **/
    @GetMapping("/get/openid")
    public BaseResult getOpenId(@RequestParam("code")String code){

        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet httpGet = new HttpGet(openIdUrl + "?appid=" + appId + "&secret=" + appSecret + "&js_code=" + code + "&grant_type=authorization_code");

        try {
            HttpResponse response = httpClient.execute(httpGet);
            String responseBody = EntityUtils.toString(response.getEntity());
            // 解析响应数据，获取用户的OpenID
            JSONObject json = JSONObject.parseObject(responseBody);

            System.out.println("=================================获取openid使用appid："+appId);
            System.out.println("=================================获取openid使用appSecret："+appSecret);
            System.out.println("=================================获取openid返回信息："+responseBody);

            String openid = json.getString("openid");
            if(StringUtils.isEmpty(openid)){
                return BaseResult.error("获取openid异常，openid="+openid);
            }

            return BaseResult.success("normal_002",openid);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return BaseResult.error("error_002");
    }

    /**
     * @author: wangmenglong
     * @date; 2024/6/17 9:41
     * @description: 获取手机号
     * @param: [code]
     * @return: util.BaseResult
     **/
    @GetMapping("/get/phoneNumber")
    public BaseResult getPhoneNumber(@RequestParam("code")String code){
        // 登录凭证不能为空
        if (StringUtils.isEmpty(code)) {
            return BaseResult.error("code 不能为空");
        }

        //获取 接口调用凭据
        HashMap<String, Object> requestParam = new HashMap<>();
        // appId
        requestParam.put("appid", appId);
        // 唯一凭证id appid:(换成自己的)
        requestParam.put("secret", appSecret);
        requestParam.put("grant_type", "client_credential");
        // 发送GET请求读取调用微信接口获取openid用户唯一标识
        String result = HttpUtil.get(WxApi.MESSAGE_ACCESS_TOKEN, requestParam);
        JSONObject jsonObject = JSONObject.parseObject(result);
        String accessToken = jsonObject.getString("access_token");

        JSONObject paramMap = new JSONObject();
        paramMap.put("code", code);
        String post =  HttpUtil.post(WxApi.PHONE_NUMBER + accessToken, paramMap.toJSONString());
        // 解析响应数据
        JSONObject json = JSONObject.parseObject(post);
        if(!"0".equals(json.getString("errcode"))){
            return BaseResult.error(json.getString("errmsg"));
        }
        JSONObject phoneInfoObj = JSONObject.parseObject(json.getString("phone_info"));
        String phoneNumber = phoneInfoObj.getString("phoneNumber");
        return BaseResult.success("normal_002",phoneNumber);
    }


    /**
     * 发送微信消息
     * @return:
     * @Author: wml
     * @Date 2024/5/22 9:39
     */
    @GetMapping("/get/message/number")
    public BaseResult getMessageNumber(HttpServletRequest req, String openId, String templateId)throws Exception{
        if(!stringRedisTemplate.opsForHash().hasKey(RedisKey.TENCENT_MESSAGE_NUMBER,openId+"_"+templateId)){
            return BaseResult.success(0);
        }
        return BaseResult.success(Integer.parseInt(stringRedisTemplate.opsForHash().get(RedisKey.TENCENT_MESSAGE_NUMBER,openId+"_"+templateId).toString()));
    }

    /**
     * 发送微信消息
     * @return:
     * @Author: wml
     * @Date 2024/5/22 9:39
     */
    @PostMapping("/add/message/number")
    public BaseResult addMessageNumber(HttpServletRequest req,@RequestBody JSONObject json)throws Exception{
        String templateId=json.getString("templateId");
        String openId=json.getString("openId");
        TencentMessageUtil.addMessageNumber(stringRedisTemplate,templateId,openId,1);
        return BaseResult.success();
    }


}
