package com.jxjy.system.controller.api;

import base.controller.BaseController;
import base.result.BaseResult;
import com.github.pagehelper.PageInfo;
import com.jxjy.system.service.ArticleService;
import data.system.Article;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author wangmenglong
 * @description: 文章管理
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/public/article")
public class ApiArticleController extends BaseController {

    @Resource
    ArticleService articleService;

    /**
     * @description: 获取文章列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/l")
    public BaseResult list(HttpServletRequest req,Article article){
        PageInit(req);
        List<Article> list = articleService.list(pageNum,pageSize,article);
        PageInfo<Article> pageInfo = new PageInfo<Article>(list);
        return BaseResult.success(pageInfo);
    }


    /**
    * @author: wangmenglong
    * @date; 2024/3/24 17:18
    * @description: 获取文章详情
    * @param: [id]
    * @return: base.result.BaseResult
    **/
    @GetMapping("/details")
    public BaseResult details(@RequestParam("id")String id){
        Article article = articleService.getDetails(id);
        return BaseResult.success(article);
    }

}
