package com.jxjy.system.controller;

import base.controller.BaseController;
import base.result.BaseResult;
import com.alibaba.fastjson.JSONObject;
import com.jxjy.system.service.UserService;
import com.github.pagehelper.PageInfo;
import data.user.User;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author wangmenglong
 * @description: 用户管理
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/user")
public class UserController extends BaseController {

    @Resource
    UserService userService;

    /**
     * @description: 获取用户列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/l")
    public BaseResult list(HttpServletRequest req,User user){
        PageInit(req);
        List<User> list = userService.list(pageNum,pageSize,user);
        PageInfo<User> pageInfo = new PageInfo<User>(list);
        return BaseResult.success(pageInfo);
    }


    /**
    * @description: 新增用户
    * @author: wangmenglong
    * @date; 2023/12/11 16:50
    * @param: [org]
    * @return: base.result.BaseResult
    **/
    @PostMapping("/c")
    public BaseResult create(@RequestBody User user){
        //判断账号是否重复
        if(userService.isHave(user.getAccount(),user.getId())){
            return BaseResult.error("error_003");
        }
        return userService.create(user)?BaseResult.success("normal_001"):BaseResult.error("error_001");
    }

    /**
     * @description: 编辑用户
     * @author: wangmenglong
     * @date; 2023/12/7 11:05
     * @param: [org]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/u")
    public BaseResult update(@RequestBody User user){
        //判断账号重复
        if(userService.isHave(user.getAccount(),user.getId())){
            return BaseResult.error("error_003");
        }
        return userService.update(user)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }

    /**
    * @description: 重置密码
    * @author: wangmenglong
    * @date; 2023/12/11 16:59
    * @param: [id]
    * @return: base.result.BaseResult
    **/
    @PostMapping("/reset")
    public BaseResult reset(@RequestBody JSONObject jsonObject){
        String id = jsonObject.getString("id");
        return userService.reset(id)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }

    /**
     * @description: 修改状态  停用/启用
     * @author: wangmenglong
     * @date; 2023/12/11 16:59
     * @param: [id]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/ustate")
    public BaseResult uState(@RequestBody JSONObject jsonObject){
        String id = jsonObject.getString("id");
        String state = jsonObject.getString("state");
        return userService.uState(id,state)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }


    /**
     * @description: 删除用户
     * @author: wangmenglong
     * @date; 2023/12/7 11:08
     * @param: [id]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/d")
    public BaseResult del(@RequestBody JSONObject jsonObject){
        String id = jsonObject.getString("id");
        return userService.del(id)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }

    /**
    * @description: 修改密码
    * @author: wangmenglong
    * @date; 2023/12/12 10:55
    * @param: [jsonObject]
    * @return: base.result.BaseResult
    **/
    @PostMapping("/upassword")
    public BaseResult uPassword(@RequestBody JSONObject jsonObject){
        String oldPassword = jsonObject.getString("oldPassword");
        String password = jsonObject.getString("password");
        String id = jsonObject.getString("id");
        return userService.uPassword(oldPassword,password,id)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }


    /**
    * @author: wangmenglong
    * @date; 2024/3/21 15:36
    * @description: 修改当前用户的密码
    * @param: [jsonObject]
    * @return: base.result.BaseResult
    **/
    @PostMapping("/u/password")
    public BaseResult updateUserPassword(@RequestBody JSONObject jsonObject){
        String oldPassword = jsonObject.getString("oldPassword");
        String password = jsonObject.getString("password");
        return userService.updateUserPassword(oldPassword,password);
    }

    /**
    * @author: wangmenglong
    * @date; 2024/3/24 17:18
    * @description: 获取用户详情
    * @param: [id]
    * @return: base.result.BaseResult
    **/
    @GetMapping("/details")
    public BaseResult details(@RequestParam("id")String id){
        User user = userService.getDetails(id);
        return BaseResult.success(user);
    }

}
