package data.system;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import data.parent.IdentityObj;
import lombok.Data;

/**
 * @author wangmenglong
 * @description: 文章
 * @date 2025/05/20 14:50
 */
@Data
@TableName(value = "tb_article")
public class Article extends IdentityObj {

    /**
     * 标题
     **/
    @TableField("title")
    private String title;

    /**
     * 内容
     **/
    @TableField("content")
    private String content;

    /**
     * 来源
     **/
    @TableField("source")
    private String source;

    /**
     * 大图
     **/
    @TableField("icon")
    private String icon;

    /**
     * 政策宣传  policy
     * 人设动态  society
     * 通知公告  notice
     **/
    @TableField("type")
    private String type;

    /**
     * 是否发布
     **/
    @TableField("`release`")
    private Boolean release;

    /**
     * 简介
     **/
    @TableField("`synopsis`")
    private String synopsis;

    /**
     * 具体字段查看数据库备注
     **/
    @TableField("case_type")
    private String caseType;

}
