package com.jxjy.system.service.impl;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxjy.system.mapper.RecruitTypeMapper;
import com.jxjy.system.service.RecruitTypeService;
import data.system.RecruitType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 *
 * @return: 招聘类型管理
 * @Author: wml
 * @Date 2025/5/9 10:22
 */
@Service
@Transactional
public class RecruitTypeServiceImpl extends ServiceImpl<RecruitTypeMapper, RecruitType> implements RecruitTypeService {



    /**
     * @description: 获取所有列表
     * @author: wangmenglong
     **/
    @Override
    public List<RecruitType> listAll(RecruitType recruitType) {
        //创建查询条件
        LambdaQueryWrapper<RecruitType> qw = new LambdaQueryWrapper<>();
        qw.like(StringUtils.isNotBlank(recruitType.getName()),RecruitType::getName,recruitType.getName())
                .eq(RecruitType::getDel,false)
                .eq(StringUtils.isNotBlank(recruitType.getBaseCode()),RecruitType::getBaseCode, recruitType.getBaseCode())
                .orderByDesc(RecruitType::getCreateTime);
        List<RecruitType> orgList = super.list(qw);
        //返回查询结果
        return orgList;
    }



}
