package com.jxjy.system.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import data.system.ObjectiveIndustry;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * @Author: wml
 * @Date 2025/5/9 10:21
 */
public interface ObjectiveIndustryMapper extends BaseMapper<ObjectiveIndustry> {


    /**
     * 根据basecode查询员工意向行业列表
     * @param baseCode 基础编码参数
     * @return 员工意向行业列表
     * @Author: wml
     * @Date 2025/9/9 10:47
     */
    @Select("<script>" +
            "SELECT a.*,b.name from tb_objective_industry a " +
            "left join tb_industry as b on b.id = a.industry_id  where a.del = 0 "+
            "<if test='baseCode != null and baseCode != \"\"'>" +
            "  and a.base_code = #{baseCode}" +
            "</if>" +
            "<if test='personId != null and personId != \"\"'>" +
            "  and a.person_id = #{personId}" +
            "</if>" +
            "<if test='industryId != null and industryId != \"\"'>" +
            "  and a.industry_id = #{industryId}" +
            "</if>" +
            "</script>")
    List<ObjectiveIndustry> listAll(@Param("baseCode") String baseCode,@Param("personId") String personId,@Param("industryId") String industryId);

}
