package com.jxjy.system.controller.api;

import base.controller.BaseController;
import base.result.BaseResult;
import com.jxjy.system.service.OrgService;
import data.system.Org;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * @author wangmenglong
 * @description: 企业管理
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/public/org")
public class ApiOrgController extends BaseController {

    @Resource
    OrgService orgService;

    /**
    * @author: wangmenglong
    * @date; 2024/3/24 17:18
    * @description: 获取企业详情
    * @param: [id]
    * @return: base.result.BaseResult
    **/
    @GetMapping("/details")
    public BaseResult details(@RequestParam("id")String id){
        Org org = orgService.getDetails(id);
        return BaseResult.success(org);
    }

    /**
     * @description: 新增企业
     * @author: wangmenglong
     * @param: [org]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/c")
    public BaseResult create(@RequestBody Org org){
        //判断是否重复
        if(orgService.isHave(org.getOpenId(),org.getId())){
            return BaseResult.error("error_004");
        }
        return orgService.create(org)?BaseResult.success("normal_001"):BaseResult.error("error_001");
    }

}
