package com.jxjy.system.controller;

import base.controller.BaseController;
import base.result.BaseResult;
import com.github.pagehelper.PageInfo;
import com.jxjy.system.service.QualificationService;
import data.system.Qualification;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author wangmenglong
 * @description: 学历
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/qualification")
public class QualificationController extends BaseController {

    @Resource
    QualificationService qualificationService;

    /**
     * @description: 获取所有招聘类型列表
     * @author: wangmenglong
     * @date; 2025/10/24 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/all")
    public BaseResult all(HttpServletRequest req, Qualification qualification){
        PageInit(req);
        List<Qualification> list = qualificationService.listAll(qualification);
        PageInfo<Qualification> pageInfo = new PageInfo<Qualification>(list);
        return BaseResult.success(pageInfo);
    }



}
