package com.jxjy.system.controller;

import base.controller.BaseController;
import base.result.BaseResult;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.jxjy.system.service.ArticleService;
import data.system.Article;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author wangmenglong
 * @description: 文章管理
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/article")
public class ArticleController extends BaseController {

    @Resource
    ArticleService articleService;

    /**
     * @description: 获取文章列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/l")
    public BaseResult list(HttpServletRequest req,Article article){
        PageInit(req);
        List<Article> list = articleService.list(pageNum,pageSize,article);
        PageInfo<Article> pageInfo = new PageInfo<Article>(list);
        return BaseResult.success(pageInfo);
    }


    /**
    * @description: 新增文章
    * @author: wangmenglong
    * @date; 2023/12/11 16:50
    * @param: [org]
    * @return: base.result.BaseResult
    **/
    @PostMapping("/c")
    public BaseResult create(@RequestBody Article article){
        return articleService.create(article)?BaseResult.success("normal_001"):BaseResult.error("error_001");
    }

    /**
     * @description: 编辑文章
     * @author: wangmenglong
     * @date; 2023/12/7 11:05
     * @param: [org]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/u")
    public BaseResult update(@RequestBody Article article){
        return articleService.update(article)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }

    /**
     * @description: 修改状态  发布未发布
     **/
    @PostMapping("/ustate")
    public BaseResult uState(@RequestBody JSONObject jsonObject){
        String id = jsonObject.getString("id");
        String state = jsonObject.getString("state");
        return articleService.uState(id,state)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }


    /**
     * @description: 删除文章
     * @author: wangmenglong
     * @date; 2023/12/7 11:08
     * @param: [id]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/d")
    public BaseResult del(@RequestBody JSONObject jsonObject){
        String id = jsonObject.getString("id");
        return articleService.del(id)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }


    /**
    * @author: wangmenglong
    * @date; 2024/3/24 17:18
    * @description: 获取文章详情
    * @param: [id]
    * @return: base.result.BaseResult
    **/
    @GetMapping("/details")
    public BaseResult details(@RequestParam("id")String id){
        Article article = articleService.getDetails(id);
        return BaseResult.success(article);
    }

}
