package util;

import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

/**
 * @Author zhangziyuan
 * @Description
 * @Date 2021/6/17
 **/
public class MultipartFileToFile {
    /**
     * MultipartFile 转 File
     *
     * @param file
     * @throws Exception
     */
    public static File multipartFileToFile(MultipartFile file) throws Exception {

        File toFile = null;
        if (file.equals("") || file.getSize() <= 0) {
            file = null;
        } else {
//            InputStream ins = null;
//            ins = file.getInputStream();
            String originalFilename = file.getOriginalFilename();
            String[] filename = originalFilename.split("\\.");
            toFile=File.createTempFile(filename[0] + UUID.randomUUID(), filename[1]);
            file.transferTo(toFile);
            //inputStreamToFile(ins, toFile);
//            ins.close();
        }
        return toFile;
    }

    //获取流文件
    private static void inputStreamToFile(InputStream ins, File file) {
        try {
            OutputStream os = new FileOutputStream(file);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = ins.read(buffer, 0, 8192)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            os.close();
            ins.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 删除本地临时文件
     *
     * @param file
     */
    public static void delteTempFile(File file) {
        if (file != null) {
//            File del = new File(file.toURI());
//           del.delete();
            file.delete();
        }
    }

}
