package mongo.parent;


import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.context.annotation.Primary;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

@Data
@Primary
abstract public class MongoIdentityObj {

    private String id;

    private Boolean del;

    private String baseCode;

    //@TableField(value = "createTime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    private String userId;

    private String userName;

    /**
    * @description: 删除时间（如果数据使用过，执行删除操作时更新del=1和删除时间；如果未使用过，直接真删）
    * @author: wangmenglong
    * @date; 2023/12/8 10:20
    **/
    private String delTime;

    public MongoIdentityObj(){
        this.del = false;
        try {
            //this.createTime = getMongoDate(new Date());
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    /**
     * 计算得到MongoDB存储的日期，（默认情况下mongo中存储的是标准的时间，中国时间是东八区，存在mongo中少8小时，所以增加8小时）
     * http://www.iteye.com/problems/88507
     *
     * @author: Gao Peng
     * @date: 2016年5月4日 上午9:26:23
     * @param: @param
     *             date
     * @param: @return
     * @return: Date
     */
    public static Date getMongoDate(Date date) throws Exception{
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.add(Calendar.HOUR_OF_DAY, 8);
        return DateUtils.parseDate(sdf.format(ca.getTime()));
    }

}
