package com.jxjy.system.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.jxjy.system.bean.auth.UserContext;
import com.jxjy.system.mapper.MessageMapper;
import com.jxjy.system.service.MessageService;
import com.jxjy.system.util.auth.UserUtils;
import com.jxjy.system.xsnowflake.SnowFlakeFactory;
import data.system.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 *
 * @return: 消息管理
 * @Author: wml
 * @Date 2025/5/9 10:22
 */
@Service
@Transactional
public class MessageServiceImpl extends ServiceImpl<MessageMapper, Message> implements MessageService {

    @Autowired
    SnowFlakeFactory snowFlakeFactory;


    /**
     * @description: 获取消息列表
     * @author: wangmenglong
     * @date; 2023/12/11 16:46
     * @param: [pageNum, pageSize]
     * @return: java.util.List<data.message.Message>
     **/
    @Override
    public List<Message> list(int pageNum, int pageSize, Message message) {
        //启动分页工具
        PageHelper.startPage(pageNum, pageSize);
        //创建查询条件
        LambdaQueryWrapper<Message> qw = new LambdaQueryWrapper<>();
        qw.eq(StringUtils.isNotBlank(message.getTitle()),Message::getTitle,message.getTitle())
                .eq(Message::getDel,false)
                .eq(StringUtils.isNotBlank(message.getBaseCode()),Message::getBaseCode, message.getBaseCode())
                .orderByDesc(Message::getCreateTime);
        List<Message> messageList = super.list(qw);
        //返回查询结果
        return messageList;
    }


    /**
     * @description: 新增消息
     * @author: wangmenglong
     * @date; 2023/12/11 16:51
     * @param: [message]
     * @return: boolean
     **/
    @Override
    public boolean create(Message message) {

        UserContext userContext = UserUtils.getUserContext();
        String baseCode = userContext.getBaseCode();

        message.setId(snowFlakeFactory.nextId());
        message.setBaseCode(baseCode);
        message.setDel(false);
        message.setCreateTime(DateUtil.now());
        message.setState("start");

        return super.save(message);
    }

    /**
     * @description: 编辑消息
     * @author: wangmenglong
     * @date; 2023/12/11 16:55
     * @param: [message]
     * @return: boolean
     **/
    @Override
    public boolean update(Message message) {
        message.setUpdateTime(DateUtil.now());
        //判断是否传入id
        if(StringUtils.isBlank(message.getId())){
            return false;
        }
        return super.saveOrUpdate(message);
    }

    /**
     * @description: 删除消息
     * @author: wangmenglong
     * @date; 2023/12/11 17:06
     * @param: [id]
     * @return: boolean
     **/
    @Override
    public boolean del(String id) {
        if(StringUtils.isBlank(id)){
            return false;
        }
        LambdaUpdateWrapper<Message> qw = new LambdaUpdateWrapper<>();
        qw.eq(Message::getId,id)
                .set(Message::getDel,true)
                .set(Message::getDelTime, DateUtil.now());

        return super.update(qw);
    }


    /**
     * @author: wangmenglong
     * @date; 2024/3/24 17:19
     * @description: 获取消息详情
     * @param: [id]
     * @return: data.message.Message
     **/
    @Override
    public Message getDetails(String id) {
        return super.getById(id);
    }

    /**
     * @author: wangmenglong
     * @date; 2024/3/24 17:19
     * @description: 获取消息详情
     * @param: [id]
     * @return: data.message.Message
     **/
    @Override
    public Message getOneMessage() {
        LambdaQueryWrapper<Message> qw = new LambdaQueryWrapper<>();
        qw.eq(Message::getDel,false)
                .eq(Message::getState,"start")
                .last("limit 1");
        return super.getOne(qw);
    }
}
