package com.jxjy.system.schedule;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.jxjy.system.service.MessageRecordService;
import com.jxjy.system.service.MessageService;
import com.jxjy.system.service.PersonService;
import com.jxjy.system.util.weixin.TencentMessageUtil;
import data.system.Message;
import data.system.MessageRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * 定时任务
 */
@Component
public class MessageSchedule {

    @Resource
    private MessageService messageService;

    @Resource
    private MessageRecordService messageRecordService;

    @Resource
    private PersonService personService;

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Value("${weixin.appid}")
    String AppId;
    @Value("${weixin.secret}")
    String Secret;
    @Value("${wechat.messagePersonnelTemplateId}")
    String MPTId;
    @Value("${wechat.messageMiniprogram}")
    String MMP;

    /**
     * 循环发送腾讯消息
     * @author: wangmenglong
     * @date: 2025/10/27
     */
    @Scheduled(cron = "0/30 * * * * ?")
    public void runner(){

        System.out.println("绛县就业定时任务");

        Message message = messageService.getOneMessage();

        if(message!=null){


            List<data.system.Person> personList = personService.getRecruitMessageList(message.getRecruitId());

            for (data.system.Person person : personList) {
                //发送腾讯消息
                MessageRecord messageRecord = new MessageRecord();
                messageRecord.setBaseCode(person.getBaseCode());
                messageRecord.setDel(false);
                messageRecord.setTitle(message.getTitle());
                messageRecord.setContent(message.getContent());
                messageRecord.setUserId(person.getId());
                messageRecord.setRecruitId(message.getRecruitId());
                messageRecord.setIsRead(false);
                messageRecord.setPersonnelId(person.getId());
                messageRecordService.create(messageRecord);

                //发送微信消息
                JSONObject json = new JSONObject();
                json.put("thing6", JSONObject.parseObject("{'value':'预支工资提醒'}"));
                json.put("thing2", JSONObject.parseObject("{'value':'预支已发放'}"));
                json.put("time9", JSONObject.parseObject("{'value':'" + DateUtil.now() + "'}"));
                json.put("thing5", JSONObject.parseObject("{'value':'点击查看详情'}"));
                //发送消息并减少数量
                //TencentMessageUtil.send(stringRedisTemplate, AppId, Secret, MPTId, "/pages/home/advanceLog/index", MMP, person.getOpenId(), json);
            }

            if(personList.size()==0){
                message.setState("end");

                messageService.update(message);
            }



        }

    }

}
