package com.jxjy.system.controller.api;

import base.controller.BaseController;
import base.result.BaseResult;
import com.github.pagehelper.PageInfo;
import com.jxjy.system.service.RecruitService;
import data.system.Recruit;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author wangmenglong
 * @description: 招聘管理
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/public/recruit")
public class ApiRecruitController extends BaseController {

    @Resource
    RecruitService recruitService;

    /**
     * @description: 获取招聘列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/l")
    public BaseResult list(HttpServletRequest req,Recruit recruit){
        PageInit(req);
        List<Recruit> list = recruitService.list(pageNum,pageSize,recruit);
        PageInfo<Recruit> pageInfo = new PageInfo<Recruit>(list);
        return BaseResult.success(pageInfo);
    }


    /**
    * @author: wangmenglong
    * @date; 2024/3/24 17:18
    * @description: 获取招聘详情
    * @param: [id]
    * @return: base.result.BaseResult
    **/
    @GetMapping("/details")
    public BaseResult details(@RequestParam("id")String id){
        Recruit recruit = recruitService.getDetails(id);
        return BaseResult.success(recruit);
    }

}
