import request from '@/utils/request'

// 招聘列表
export function recruitList(query) {
    return request({
        url: '/recruit/l',
        method: 'get',
        params: query
    })
}
// 删除
export function recruitDel(query) {
    return request({
        url: '/recruit/d',
        method: 'post',
        data: query
    })
}
// 新增招聘
export function recruitSave(query) {
    return request({
        url: query.id ? '/recruit/u' : '/recruit/c',
        method: 'post',
        data: query
    })
}
export function uploadRecruit(query) {
    return request({
        url: '/public/import/recruit/upload/51job/json',
        method: 'post',
        data: query
    })
}
// 招聘类型
export function recruitTypeAll(query) {
    return request({
        url: '/recruit/type/all',
        method: 'get',
        params: query
    })
}
// 经验要求列表
export function experienceAll(query) {
    return request({
        url: '/experience/all',
        method: 'get',
        params: query
    })
}
// 学历要求
export function qualificationAll(query) {
    return request({
        url: '/qualification/all',
        method: 'get',
        params: query
    })
}
// 招聘列表
export function orgListAll(query) {
    return request({
        url: '/org/l',
        method: 'get',
        params: query
    })
}
// 行业列表
export function industryListAll(query) {
    return request({
        url: '/industry/l/all',
        method: 'get',
        params: query
    })
}
// 上下架
export function recruitStatus(query) {
    return request({
        url: '/recruit/u/status',
        method: 'post',
        data: query
    })
}