import { createWebHistory, createRouter,createWebHashHistory } from 'vue-router'
/* Layout */
import Layout from '@/layout'

/**
 * Note: 路由配置项
 *
 * hidden: true                     // 当设置 true 的时候该路由不会再侧边栏出现 如401，login等页面，或者如一些编辑页面/edit/1
 * alwaysShow: true                 // 当你一个路由下面的 children 声明的路由大于1个时，自动会变成嵌套的模式--如组件页面
 * redirect                         // 默认跳转路径
 * name:'router-name'               // 设定路由的名字，一定要填写不然使用<keep-alive>时会出现各种问题
 * query: '{"id": 1, "name": "ry"}' // 访问路由的默认传递参数
 * roles: ['admin', 'common']       // 访问路由的角色权限
 * permissions: ['a:a:a', 'b:b:b']  // 访问路由的菜单权限
 * meta : {
    noCache: true                   // 如果设置为true，则不会被 <keep-alive> 缓存(默认 false)
    title: 'title'                  // 设置该路由在侧边栏和面包屑中展示的名字
    icon: 'svg-name'                // 设置该路由的图标，对应路径src/assets/icons/svg
    breadcrumb: false               // 如果设置为false，则不会在breadcrumb面包屑中显示
    activeMenu: '/system/user'      // 当路由设置了该属性，则会高亮相对应的侧边栏。
    clickable: noRedirect             // 当设置 noRedirect 的时候该路由在面包屑导航中不可被点击
    preTitle // 面包屑导航上层的名称
    preTitle2 // 面包屑导航preTitle之后与本页面之间的名称
  }
 */

// 公共路由
export const constantRoutes = [
  {
    path: '/login',
    component: () => import('@/views/login'),
    hidden: true
  },
  {
    path: "/:pathMatch(.*)*",
    component: () => import('@/views/error/404'),
    hidden: true
  },
  {
    path: '/401',
    component: () => import('@/views/error/401'),
    hidden: true
  },
  
  {
    path: '/',
    component: Layout,
    redirect: '/recruit',
    children: [
      {
        path: 'recruit',
        component: () => import('@/views/recruit/index'),
        name: '',
        meta: { title: '招聘管理', icon: 'dashboard' }
      },
    ]
  },
  {
    path: '/enterprise',
    component: Layout,
    redirect: '/enterprise',
    children: [
      {
        path: '',
        component: () => import('@/views/enterprise/index'),
        name: '',
        meta: { title: '企业管理', icon: 'dashboard' }
      },
    ]
  },
  {
    path: '/industry',
    component: Layout,
    redirect: '/industry',
    children: [
      {
        path: '',
        component: () => import('@/views/industry/index'),
        name: '',
        meta: { title: '行业管理', icon: 'dashboard' }
      },
    ]
  },
  {
    path: '/personnel',
    component: Layout,
    redirect: '/personnel',
    children: [
      {
        path: '',
        component: () => import('@/views/personnel/index'),
        name: '',
        meta: { title: '人员管理', icon: 'dashboard' }
      },
    ]
  },
  {
    path: '/registration',
    component: Layout,
    redirect: '/registration',
    children: [
      {
        path: '',
        component: () => import('@/views/registration/index'),
        name: '',
        meta: { title: '报名管理', icon: 'dashboard' }
      },
    ]
  },
  {
    path: '/account',
    component: Layout,
    redirect: '/account',
    children: [
      {
        path: '',
        component: () => import('@/views/account'),
        name: 'account',
        meta: { title: '账号管理', icon: 'list' }
      },
    ]
  },
  {
    path: '/editPassword',
    component: Layout,
    redirect: '/editPassword',
    children: [
      {
        path: '',
        component: () => import('@/views/editPassword'),
        name: 'editPassword',
        meta: { title: '修改密码', icon: 'password' }
      },
    ]
  },
]

// 动态路由，基于用户权限动态去加载
export const dynamicRoutes = []

const router = createRouter({
  history: createWebHashHistory(),
  routes: constantRoutes,
  scrollBehavior(to, from, savedPosition) {
    if (savedPosition) {
      return savedPosition
    } else {
      return { top: 0 }
    }
  },
});

export default router;
