import http from '../http.js'
import {getAreaText} from './area.js'
let resumeInfo = {}
export const getResume = async (applyId,callback) => {
	const res = await http.post('/public/ali/info/get', {biz_token: applyId})
	const info = JSON.parse(res.code)
	const resumeInfo = info.alipay_ebpp_industry_job_resumeauthlogininfo_get_response.resume_attributes
	const careerObjective = info.alipay_ebpp_industry_job_resumeauthlogininfo_get_response.user_intention_info
	uni.request({
		// url: 'http://192.168.0.6:8000/loginform',
		url: 'https://jyzp.365jft.com/jfb-recruit/loginform',
		method: 'POST',
		data: {
			account: uni.getStorageSync('openId'),
			wxType: 'wx'
		},
		header: {
		  'Content-Type': 'application/x-www-form-urlencoded'
		},
		success: async (res) => {
		  console.log('请求成功', res);
		  uni.setStorageSync('jy-recruit-token',res.data.token)
		  const res1 = await http.get('/person/person/details', {})
		  if (res1.data &&res1.data.name) {
			  callback()
			  return;
		  }
		  // 基本信息
		  const baseInfo = {}
		  baseInfo.id = res1.data.id
		  if (resumeInfo.find(item => item.attribute_key == 'real_name')) {
		  	baseInfo.name = resumeInfo.find(item => item.attribute_key == 'real_name').attribute_value
		  }
		  if (resumeInfo.find(item => item.attribute_key == 'phone')) {
		  	baseInfo.phoneNumber = resumeInfo.find(item => item.attribute_key == 'phone').attribute_value
		  }
		  const gender = resumeInfo.find(item => item.attribute_key == 'gender')
		  if (gender && gender.attribute_value) {
		  	baseInfo.sex = gender.attribute_value == 'male'
		  }
		  const res2 = await http.post('/person/u', baseInfo)
		  if (careerObjective.expect_job_type) {
				const areaL = getAreaText(careerObjective.city_code)
				const lastHyphenIndex = careerObjective.expect_job_type.lastIndexOf("-")
				const industryName = careerObjective.expect_job_type.substring(lastHyphenIndex + 1);
				http.post('/objective/c', {
				  industryName,
				  province: areaL[0],
				  city: areaL[1],
				  salaryMin: careerObjective.expect_salary_min,
				  salaryMax: careerObjective.expect_salary_max,
				  workType: careerObjective.work_nature,
				  personId: res1.data.id
				}).then(res => {
					callback()
				}).catch(err => {
					callback()
				})
		  } else {
			  callback()
		  }
		  // 工作经历
		  const work_experience = resumeInfo.find(item => item.attribute_key == 'work_experience')
		  if (work_experience && work_experience.attribute_value) {
		  	let workList =  JSON.parse(work_experience.attribute_value)
			console.log('workList',workList)
		  	for(const item of workList) {
				item.start_date = item.start_date.replace('.', '-');
				item.item.end_date = item.item.end_date.replace('.', '-');
				originalStr.replace('.', '-');
		  		http.post('/workExperience/c', {
		  			orgName: item.company,
		  			job: item.position_name,
		  			startTime: item.start_date,
		  			endTime: item.end_date,
		  			industryName: item.position_name,
		  			descr: item.content,
					personId: res1.data.id
		  		})
		  	}
		  }
		},
		fail: (err) => {
		  uni.showToast({
		  	title: `登录失败`,
		  	icon: 'none',
		  })
		}
	});
}
