package com.jfb.recruit.controller;

import base.controller.BaseController;
import base.result.BaseResult;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.jfb.recruit.service.RecruitTypeService;
import data.recruit.RecruitType;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author wangmenglong
 * @description: 招聘类型
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/recruit/type")
public class RecruitTypeController extends BaseController {

    @Resource
    RecruitTypeService recruitTypeService;

    /**
     * @description: 获取所有招聘类型列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/all")
    public BaseResult all(HttpServletRequest req, RecruitType recrutiType){
        PageInit(req);
        List<RecruitType> list = recruitTypeService.listAll(recrutiType);
        PageInfo<RecruitType> pageInfo = new PageInfo<RecruitType>(list);
        return BaseResult.success(pageInfo);
    }



}
