package com.jfb.recruit.controller;

import base.controller.BaseController;
import base.result.BaseResult;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.jfb.recruit.bean.auth.UserContext;
import com.jfb.recruit.service.ObjectiveService;
import com.jfb.recruit.util.auth.UserUtils;
import data.recruit.Objective;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author wangmenglong
 * @description: 求职意向管理
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/objective")
public class ObjectiveController extends BaseController {

    @Resource
    ObjectiveService objectiveService;

    /**
     * @description: 获取求职意向列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/l")
    public BaseResult list(HttpServletRequest req,Objective objective){
        PageInit(req);
        UserContext userContext = UserUtils.getUserContext();
        objective.setBaseCode(userContext.getBaseCode());
        List<Objective> list = objectiveService.list(pageNum,pageSize,objective);
        PageInfo<Objective> pageInfo = new PageInfo<Objective>(list);
        return BaseResult.success(pageInfo);
    }


    /**
    * @description: 新增求职意向
    * @author: wangmenglong
    * @param: [objective]
    * @return: base.result.BaseResult
    **/
    @PostMapping("/c")
    public BaseResult create(@RequestBody Objective objective){

        //判断是否重复
        if(objectiveService.isHave(objective.getUserId(),objective.getIndustryId(),objective.getId())){
            return BaseResult.error("error_008");
        }

        return objectiveService.create(objective)?BaseResult.success("normal_001"):BaseResult.error("error_001");
    }

    /**
     * @description: 编辑求职意向
     * @author: wangmenglong
     * @param: [objective]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/u")
    public BaseResult update(@RequestBody Objective objective){
        //判断是否重复
        if(objectiveService.isHave(objective.getUserId(),objective.getIndustryId(),objective.getId())){
            return BaseResult.error("error_008");
        }
        return objectiveService.update(objective)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }

    /**
     * @description: 删除求职意向
     * @author: wangmenglong
     * @date; 2023/12/7 11:08
     * @param: [id]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/d")
    public BaseResult del(@RequestBody JSONObject jsonObject){
        String id = jsonObject.getString("id");
        return objectiveService.del(id)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }

    /**
    * @author: wangmenglong
    * @date; 2024/3/24 17:18
    * @description: 获取求职意向详情
    * @param: [id]
    * @return: base.result.BaseResult
    **/
    @GetMapping("/details")
    public BaseResult details(@RequestParam("id")String id){
        Objective objective = objectiveService.getDetails(id);
        return BaseResult.success(objective);
    }

}
