package com.jfb.recruit.controller.api;

import base.controller.BaseController;
import base.result.BaseResult;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jfb.recruit.bean.auth.UserContext;
import com.jfb.recruit.service.OrgService;
import com.jfb.recruit.service.RecruitService;
import com.jfb.recruit.util.Excelutils.ExcelAppendUtil;
import com.jfb.recruit.util.Excelutils.JobsExcel;
import com.jfb.recruit.util.Excelutils.OrgExcel;
import com.jfb.recruit.util.Excelutils.OrgExcelAppendUtil;
import com.jfb.recruit.util.auth.UserUtils;
import com.jfb.recruit.xsnowflake.SnowFlakeFactory;
import data.recruit.Org;
import data.recruit.Recruit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.*;

/**
 * @author wangmenglong
 * @description: 招聘管理
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/public/import/recruit")
public class ImportRecruitController extends BaseController {

    @Resource
    RecruitService recruitService;

    @Autowired
    SnowFlakeFactory snowFlakeFactory;

    @Autowired
    private ThreadPoolTaskExecutor taskExecutor;

    @Resource
    OrgService orgService;

    // 桌面的Excel文件名（可自定义，如：upload_record.xlsx）
    private static final String EXCEL_FILE_NAME = "/pchongshuju/show.xlsx";

    private static final String EXCEL_FILE_ORG_NAME = "/pchongshuju/showOrg.xlsx";
    /**
     * 文件上传接口导出excel
     * @param file 上传的文件
     * @param remark 备注（可选，前端传）
     * @return 上传结果
     */
    @PostMapping("/upload/job")
    public BaseResult uploadFile(
            @RequestParam("file") MultipartFile file,
            @RequestParam(value = "remark", defaultValue = "无备注") String remark) {

        // 1. 校验文件是否为空
        if (file.isEmpty()) {
            return BaseResult.error("001");
        }

        // 2. 校验文件类型（增强严谨性，避免OOXML错误）
        String originalFilename = file.getOriginalFilename();
        // 优化：双重校验（后缀+内容类型，防止改后缀的非JSON文件）
        if (originalFilename == null || !originalFilename.trim().toLowerCase().endsWith(".json")) {
            return BaseResult.error("002");
        }
        // 可选：额外校验Content-Type，进一步防止非JSON文件
        String contentType = file.getContentType();
        if (contentType != null && !contentType.equalsIgnoreCase("application/json")
                && !contentType.equalsIgnoreCase("text/plain")) {
            return BaseResult.error("002");
        }

        // 3. 读取文件全部内容（确保流仅用于文本读取，避免被Office解析库误处理）
        StringBuilder jsonContent = new StringBuilder();
        // 核心：仅用BufferedReader读取文本，不引入任何Office解析逻辑
        try (BufferedReader reader = new BufferedReader(
                new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8) // 强制UTF-8，避免乱码
        )) {
            String line;
            while ((line = reader.readLine()) != null) {
                jsonContent.append(line);
            }


            JSONArray jsonArray = JSONArray.parseArray(jsonContent.toString());


            // 3. 调用工具类追加数据（EasyExcel支持批量，这里单条也用列表）
            List<JobsExcel> dataList = new ArrayList<>();



            for (int i = 0; i < jsonArray.size(); i++) {

                JSONObject jsonObject = jsonArray.getJSONObject(i);

                // 2. 封装要追加到Excel的数据
                JobsExcel jobsExcel = new JobsExcel();
                jobsExcel.setJonName(jsonObject.getString("jobName"));
                jobsExcel.setFullCompanyName(jsonObject.getString("fullCompanyName"));
                jobsExcel.setJobSalaryMin(jsonObject.getString("jobSalaryMin"));
                jobsExcel.setJobSalaryMax(jsonObject.getString("jobSalaryMax"));
                jobsExcel.setJobDescribe(jsonObject.getString("jobDescribe"));

                dataList.add(jobsExcel);

            }

            ExcelAppendUtil.appendDataToExcel(EXCEL_FILE_NAME, dataList);


            // 4. 返回成功响应
            return BaseResult.success(); // 优化：确保返回字符串类型

        } catch (IOException e) {
            return BaseResult.error("003");
        }


    }

    /**
     * 文件上传接口导出excel
     * @param file 上传的文件
     * @param remark 备注（可选，前端传）
     * @return 上传结果
     */
    @PostMapping("/upload/org")
    public BaseResult uploadFileOrg(
            @RequestParam("file") MultipartFile file,
            @RequestParam(value = "remark", defaultValue = "无备注") String remark) {

        // 1. 校验文件是否为空
        if (file.isEmpty()) {
            return BaseResult.error("001");
        }

        // 2. 校验文件类型（增强严谨性，避免OOXML错误）
        String originalFilename = file.getOriginalFilename();
        // 优化：双重校验（后缀+内容类型，防止改后缀的非JSON文件）
        if (originalFilename == null || !originalFilename.trim().toLowerCase().endsWith(".json")) {
            return BaseResult.error("002");
        }
        // 可选：额外校验Content-Type，进一步防止非JSON文件
        String contentType = file.getContentType();
        if (contentType != null && !contentType.equalsIgnoreCase("application/json")
                && !contentType.equalsIgnoreCase("text/plain")) {
            return BaseResult.error("002");
        }

        // 3. 读取文件全部内容（确保流仅用于文本读取，避免被Office解析库误处理）
        StringBuilder jsonContent = new StringBuilder();
        // 核心：仅用BufferedReader读取文本，不引入任何Office解析逻辑
        try (BufferedReader reader = new BufferedReader(
                new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8) // 强制UTF-8，避免乱码
        )) {
            String line;
            while ((line = reader.readLine()) != null) {
                jsonContent.append(line);
            }


            JSONArray jsonArray = JSONArray.parseArray(jsonContent.toString());


            // 3. 调用工具类追加数据（EasyExcel支持批量，这里单条也用列表）
            List<OrgExcel> dataList = new ArrayList<>();



            for (int i = 0; i < jsonArray.size(); i++) {

                JSONObject jsonObject = jsonArray.getJSONObject(i);

                // 2. 封装要追加到Excel的数据
                OrgExcel jobsExcel = new OrgExcel();
                jobsExcel.setName(jsonObject.getString("name"));
                jobsExcel.setIntro(jsonObject.getString("intro"));
                jobsExcel.setAddress(jsonObject.getString("address"));

                dataList.add(jobsExcel);

            }

            OrgExcelAppendUtil.appendDataToExcel(EXCEL_FILE_ORG_NAME, dataList);


            // 4. 返回成功响应
            return BaseResult.success(); // 优化：确保返回字符串类型

        } catch (IOException e) {
            return BaseResult.error("003");
        }


    }


    /**
     * 获取企业url
     * @return: base.result.BaseResult
     * @Author: wml
     * @Date 2026/1/12 15:33
     */
    @PostMapping(value = "/upload/51job/org/url/json", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    public BaseResult uploadJsonOrgUrlFile(HttpServletRequest req,@RequestParam("file") MultipartFile file) {

        // 1. 校验文件是否为空
        if (file.isEmpty()) {
            return BaseResult.error("001");
        }

        // 2. 校验文件类型（增强严谨性，避免OOXML错误）
        String originalFilename = file.getOriginalFilename();
        // 优化：双重校验（后缀+内容类型，防止改后缀的非JSON文件）
        if (originalFilename == null || !originalFilename.trim().toLowerCase().endsWith(".json")) {
            return BaseResult.error("002");
        }
        // 可选：额外校验Content-Type，进一步防止非JSON文件
        String contentType = file.getContentType();
        if (contentType != null && !contentType.equalsIgnoreCase("application/json")
                && !contentType.equalsIgnoreCase("text/plain")) {
            return BaseResult.error("002");
        }

        // 3. 读取文件全部内容（确保流仅用于文本读取，避免被Office解析库误处理）
        StringBuilder jsonContent = new StringBuilder();
        // 核心：仅用BufferedReader读取文本，不引入任何Office解析逻辑
        try (BufferedReader reader = new BufferedReader(
                new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8) // 强制UTF-8，避免乱码
        )) {
            String line;
            while ((line = reader.readLine()) != null) {
                jsonContent.append(line);
            }

            List<String> list = new ArrayList<>();

            JSONArray jsonArray = JSONArray.parseArray(jsonContent.toString());

            for (int i = 0; i < jsonArray.size(); i++) {

                JSONObject jsonObject = jsonArray.getJSONObject(i);

                list.add(jsonObject.getString("companyHref"));

            }

            // 4. 返回成功响应
            return BaseResult.success(list); // 优化：确保返回字符串类型

        } catch (IOException e) {
            return BaseResult.error("003");
        }
    }

    /**
     * 保存信息
     * @return: base.result.BaseResult
     * @Author: wml
     * @Date 2026/1/12 15:33
     */
    @PostMapping(value = "/upload/51job/org/json")
    public BaseResult uploadJsonOrgFile(HttpServletRequest req,@RequestParam("file") MultipartFile file) {

        UserContext userContext = UserUtils.getUserContext();
        String userId = userContext.getUserId();
        String baseCode = userContext.getBaseCode();
        String userName = userContext.getUsername();

        // 1. 提交异步任务到线程池（后台执行）
        taskExecutor.execute(() -> {

            String regionCode = req.getParameter("regionCode");
            String province = req.getParameter("province");
            String city = req.getParameter("city");
            String region = req.getParameter("region");

            // 1. 校验文件是否为空
            if (file.isEmpty()) {
                System.out.println("文件为空------------------------------------------------------");
            }

            // 2. 校验文件类型（增强严谨性，避免OOXML错误）
            String originalFilename = file.getOriginalFilename();
            // 优化：双重校验（后缀+内容类型，防止改后缀的非JSON文件）
            if (originalFilename == null || !originalFilename.trim().toLowerCase().endsWith(".json")) {
                System.out.println("格式错误------------------------------------------------------");
            }
            // 可选：额外校验Content-Type，进一步防止非JSON文件
            String contentType = file.getContentType();
            if (contentType != null && !contentType.equalsIgnoreCase("application/json")
                    && !contentType.equalsIgnoreCase("text/plain")) {
                System.out.println("格式错误------------------------------------------------------");
            }

            // 3. 读取文件全部内容（确保流仅用于文本读取，避免被Office解析库误处理）
            StringBuilder jsonContent = new StringBuilder();
            // 核心：仅用BufferedReader读取文本，不引入任何Office解析逻辑
            try (BufferedReader reader = new BufferedReader(
                    new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8) // 强制UTF-8，避免乱码
            )) {
                String line;
                while ((line = reader.readLine()) != null) {
                    jsonContent.append(line);
                }

                JSONArray jsonArray = JSONArray.parseArray(jsonContent.toString());


                for (int i = 0; i < jsonArray.size(); i++) {

                    try {
                        Thread.sleep(100);
                    }catch (Exception e){
                        System.out.println("上传失败------------------------------------------------------");
                    }

                    JSONObject jsonObject = jsonArray.getJSONObject(i);

                    Org orgDetails = orgService.getName(jsonObject.getString("name"));

                    if (orgDetails == null) {

                        Org org = new Org();
                        org.setId(snowFlakeFactory.nextId());
                        org.setName(jsonObject.getString("name"));
                        org.setDescr(jsonObject.getString("intro"));
                        org.setAddress(jsonObject.getString("address"));
                        org.setRegionCode(regionCode);
                        org.setRegion(region);
                        org.setProvince(province);
                        org.setCity(city);
                        org.setBaseCode(baseCode);
                        org.setUserId(userId);
                        org.setUserName(userName);
                        orgService.create(org);
                        System.out.println("开始创建------------------------------------------------------第"+i+"条,总共"+jsonArray.size()+"条");
                    }

                }


                System.out.println("上传完成------------------------------------------------------");

            } catch (IOException e) {
                System.out.println("io错误------------------------------------------------------");
            }

        });

        return BaseResult.success(); // 优化：确保返回字符串类型
    }

    /**
     * 保存信息
     * @return: base.result.BaseResult
     * @Author: wml
     * @Date 2026/1/12 15:33
     */
    @PostMapping(value = "/upload/51job/json")
    public BaseResult uploadJsonFile(HttpServletRequest req,@RequestParam("file") MultipartFile file) {

        UserContext userContext = UserUtils.getUserContext();
        String userId = userContext.getUserId();
        String baseCode = userContext.getBaseCode();
        String userName = userContext.getUsername();

        // 1. 提交异步任务到线程池（后台执行）
        taskExecutor.execute(() -> {

            String recruitTypeId = req.getParameter("recruitTypeId");
            String recruitType = req.getParameter("recruitType");
            String experienceId = req.getParameter("experienceId");
            String experience = req.getParameter("experience");
            String qualificationId = req.getParameter("qualificationId");
            String qualification = req.getParameter("qualification");
            String payTimes = req.getParameter("payTimes");
            String startDate = req.getParameter("startDate");
            String expiredDate = req.getParameter("expiredDate");
            String qualificationCode = req.getParameter("qualificationCode");
            String experienceCode = req.getParameter("experienceCode");
            String province = req.getParameter("province");
            String city = req.getParameter("city");
            String region = req.getParameter("region");
            String oneIndustryName = req.getParameter("oneIndustryName");
            String oneIndustryId = req.getParameter("oneIndustryId");
            String towIndustryName = req.getParameter("towIndustryName");
            String towIndustryId = req.getParameter("towIndustryId");
            String industryCode = req.getParameter("industryCode");
            String regionCode = req.getParameter("regionCode");
            String industryName = req.getParameter("industryName");
            String times = req.getParameter("times");

            // 1. 校验文件是否为空
            if (file.isEmpty()) {
                System.out.println("文件为空------------------------------------------------------");
            }

            // 2. 校验文件类型（增强严谨性，避免OOXML错误）
            String originalFilename = file.getOriginalFilename();
            // 优化：双重校验（后缀+内容类型，防止改后缀的非JSON文件）
            if (originalFilename == null || !originalFilename.trim().toLowerCase().endsWith(".json")) {
                System.out.println("文件类型错误------------------------------------------------------");
            }
            // 可选：额外校验Content-Type，进一步防止非JSON文件
            String contentType = file.getContentType();
            if (contentType != null && !contentType.equalsIgnoreCase("application/json")
                    && !contentType.equalsIgnoreCase("text/plain")) {
                System.out.println("文件类型错误------------------------------------------------------");
            }

            // 3. 读取文件全部内容（确保流仅用于文本读取，避免被Office解析库误处理）
            StringBuilder jsonContent = new StringBuilder();
            // 核心：仅用BufferedReader读取文本，不引入任何Office解析逻辑
            try (BufferedReader reader = new BufferedReader(
                    new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8) // 强制UTF-8，避免乱码
            )) {
                String line;
                while ((line = reader.readLine()) != null) {
                    jsonContent.append(line);
                }

                JSONArray jsonArray = JSONArray.parseArray(jsonContent.toString());


                for (int i = 0; i < jsonArray.size(); i++) {

                    JSONObject jsonObject = jsonArray.getJSONObject(i);

                    Org orgDetails = orgService.getName(jsonObject.getString("fullCompanyName"));

                    if(orgDetails==null){
                        orgDetails = new Org();
                        orgDetails.setName(jsonObject.getString("fullCompanyName"));
                        orgDetails.setDescr(jsonObject.getString("fullCompanyName")+"诚聘");
                        orgDetails.setRegionCode(regionCode);
                        orgDetails.setRegion(region);
                        orgDetails.setProvince(province);
                        orgDetails.setCity(city);
                        orgDetails.setId(snowFlakeFactory.nextId());
                        orgDetails.setBaseCode(baseCode);
                        orgDetails.setUserId(userId);
                        orgDetails.setUserName(userName);
                        orgService.create(orgDetails);
                    }

                    if(orgDetails!=null&& StringUtils.isNotBlank(orgDetails.getId())){

                        Recruit recruit = new Recruit();
                        recruit.setId(snowFlakeFactory.nextId());
                        recruit.setBaseCode(baseCode);
                        recruit.setUserId(userId);
                        recruit.setUserName(userName);
                        recruit.setRecruitType(recruitType);
                        recruit.setRecruitTypeId(recruitTypeId);
                        recruit.setExperience(experience);
                        recruit.setExperienceId(experienceId);
                        recruit.setQualification(qualification);
                        recruit.setQualificationId(qualificationId);
                        recruit.setPayTimes(Integer.parseInt(payTimes));
                        recruit.setStartDate(startDate);
                        recruit.setExpiredDate(expiredDate);
                        recruit.setQualificationCode(qualificationCode);
                        recruit.setExperienceCode(experienceCode);
                        recruit.setProvince(province);
                        recruit.setCity(city);
                        recruit.setRegion(region);
                        recruit.setOneIndustryName(oneIndustryName);
                        recruit.setOneIndustryId(oneIndustryId);
                        recruit.setTowIndustryName(towIndustryName);
                        recruit.setTowIndustryId(towIndustryId);
                        recruit.setIndustryName(industryName);
                        recruit.setIndustryCode(industryCode);
                        recruit.setTimes(Integer.parseInt(times));
                        recruit.setAddress(orgDetails.getProvince()+orgDetails.getCity()+orgDetails.getRegion()+orgDetails.getAddress());
                        recruit.setName(jsonObject.getString("jobName"));
                        recruit.setDetails(jsonObject.getString("jobDescribe"));
                        recruit.setSalaryMax(jsonObject.getInteger("jobSalaryMax"));
                        recruit.setSalaryMin(jsonObject.getInteger("jobSalaryMin"));
                        recruit.setOrgId(orgDetails.getId());
                        recruit.setOrgName(orgDetails.getName());
                        recruit.setBatch("1");
                        recruit.setBatchSend("0");
                        recruit.setStatus("up");

                        if(StringUtils.isBlank(jsonObject.getString("jobSalaryMax"))||StringUtils.isBlank(jsonObject.getString("jobSalaryMin"))){
                            recruit.setSalaryMax(5000);
                            recruit.setSalaryMin(4000);
                        }

                        recruitService.create(recruit);

                        recruit.setOrg(orgDetails);

                        try {
                            Thread.sleep(500);
                            System.out.println("开始发送------------------------------------------------------第"+i+"条,总共"+jsonArray.size()+"条");
                            recruitService.sendAli(recruit);
                        }catch (Exception e){
                            e.printStackTrace();
                        }

                    }
                }


                // 4. 返回成功响应
                System.out.println("完成导入------------------------------------------------------");

            } catch (IOException e) {
                System.out.println("io异常------------------------------------------------------");
            }

        });

        return BaseResult.success(); // 优化：确保返回字符串类型
    }



    /**
     * 保存信息
     * @return: base.result.BaseResult
     * @Author: wml
     * @Date 2026/1/12 15:33
     */
    @GetMapping(value = "/repeat/recruit")
    public BaseResult repeatRecruit(HttpServletRequest req) {

        String batch = req.getParameter("batch");
        String startDate = req.getParameter("startDate");
        String expiredDate = req.getParameter("expiredDate");

        // 1. 提交异步任务到线程池（后台执行）
        taskExecutor.execute(() -> {

            Recruit recruit = new Recruit();
            recruit.setBatch(batch);
            recruit.setBatchSend("0");
            List<Recruit> list = recruitService.listAll(recruit);

            recruitService.updateSendAll(batch);

            for (int i = 0; i < list.size(); i++) {

                Recruit data = list.get(i);
                data.setStartDate(startDate);
                data.setExpiredDate(expiredDate);
                data.setBatchSend("0");
                data.setStatus("up");
                data.setId(snowFlakeFactory.nextId());
                recruitService.create(data);
                try {
                    Thread.sleep(500);
                    System.out.println("开始发送------------------------------------------------------第"+i+"条");
                    recruitService.sendAli(data);
                }catch (Exception e){
                    e.printStackTrace();
                }

            }

            System.out.println("完成发送------------------------------------------------------");

        });

        return BaseResult.success(); // 优化：确保返回字符串类型
    }



    public static void main(String[] args) {
        // 原始带重复元素的字符串数组
        String[] originalArray = {

                "https://jobs.51job.com/all/coVToBZQVjDzQEaFE2UT0.html",
                "https://jobs.51job.com/all/coVToBZQVjDzQEaFE2UT0.html"
        };

        // 1. 将String数组转为LinkedHashSet，自动去重且保留顺序
        Set<String> stringSet = new LinkedHashSet<>(Arrays.asList(originalArray));
        // 若不需要顺序，可替换为HashSet（效率略高）：new HashSet<>(Arrays.asList(originalArray))

        // 2. 将Set转回String数组
        String[] deduplicatedArray = stringSet.toArray(new String[0]);

        // 打印去重结果
        System.out.println("去重后的String数组：" + Arrays.toString(deduplicatedArray));

        // 2. 逐个打印元素（能看到真实的字符串内容，包含引号的本质）
        System.out.println("逐个打印元素：");
        for (String str : deduplicatedArray) {
            // 手动加引号，证明元素本身是字符串
            System.out.println("\"" + str + "\",");
        }
    }

    //随机分配人员 sql

//    UPDATE tb_recruit t1
//    JOIN (
//                    SELECT id
//     FROM tb_recruit
//             WHERE user_id = "782244953777639424"
//             ORDER BY RAND()
//    LIMIT 500
//            ) t2 ON t1.id = t2.id
//    SET t1.user_id = "766240679448940544" , user_name = "李小庆"



}
